"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPGRADE_TO_PLATINUM_SUBTITLE = exports.UPGRADE_TO_PLATINUM = exports.UPGRADE_SUBSCRIPTION = exports.UPCOMING = exports.UNARCHIVE_MODAL_TITLE = exports.UNARCHIVE_MODAL_SUBTITLE = exports.TABLE_STATUS_UPCOMING = exports.TABLE_STATUS_RUNNING = exports.TABLE_STATUS_FINISHED = exports.TABLE_STATUS_ARCHIVED = exports.TABLE_STATUS = exports.TABLE_START_TIME = exports.TABLE_END_TIME = exports.TABLE_ALERTS_TOOLTIP = exports.TABLE_ALERTS = exports.TABLE_ACTION_UNARCHIVE = exports.TABLE_ACTION_EDIT = exports.TABLE_ACTION_CANCEL_AND_ARCHIVE = exports.TABLE_ACTION_CANCEL = exports.START_TRIAL = exports.SAVE_MAINTENANCE_WINDOW = exports.REFRESH = exports.READ_ONLY_BADGE_TOOLTIP = exports.READ_ONLY_BADGE_TEXT = exports.NAME = exports.MAINTENANCE_WINDOWS_RETURN_LINK = exports.MAINTENANCE_WINDOWS_DESCRIPTION = exports.MAINTENANCE_WINDOWS = exports.EXPERIMENTAL_LABEL = exports.EXPERIMENTAL_DESCRIPTION = exports.EMPTY_PROMPT_TITLE = exports.EMPTY_PROMPT_DOCUMENTATION = exports.EMPTY_PROMPT_DESCRIPTION = exports.EMPTY_PROMPT_BUTTON = exports.EDIT_MAINTENANCE_WINDOW = exports.CREATE_NEW_BUTTON = exports.CREATE_MAINTENANCE_WINDOW_DESCRIPTION = exports.CREATE_MAINTENANCE_WINDOW = exports.CREATE_FORM_YEARLY_BY_MONTH_SUMMARY = exports.CREATE_FORM_WEEKLY_SUMMARY = exports.CREATE_FORM_WEEKDAY_SHORT = exports.CREATE_FORM_UNTIL_DATE_SUMMARY = exports.CREATE_FORM_TIMEZONE = exports.CREATE_FORM_TIMEFRAME_TITLE = exports.CREATE_FORM_TIMEFRAME_DESCRIPTION = exports.CREATE_FORM_SCOPED_QUERY_TOGGLE_TITLE = exports.CREATE_FORM_SCOPED_QUERY_TITLE = exports.CREATE_FORM_SCOPED_QUERY_INVALID_ERROR_MESSAGE = exports.CREATE_FORM_SCOPED_QUERY_EMPTY_ERROR_MESSAGE = exports.CREATE_FORM_SCOPED_QUERY_DESCRIPTION = exports.CREATE_FORM_SCHEDULE_INVALID = exports.CREATE_FORM_SCHEDULE = exports.CREATE_FORM_REPEAT = exports.CREATE_FORM_RECURRING_SUMMARY_PREFIX = exports.CREATE_FORM_RECURRING_SUMMARY = exports.CREATE_FORM_OCURRENCES_SUMMARY = exports.CREATE_FORM_NAME_REQUIRED = exports.CREATE_FORM_MONTHLY_BY_DAY_SUMMARY = exports.CREATE_FORM_INTERVAL_REQUIRED = exports.CREATE_FORM_INTERVAL_EVERY = exports.CREATE_FORM_FREQUENCY_YEARLY_ON = exports.CREATE_FORM_FREQUENCY_YEARLY = exports.CREATE_FORM_FREQUENCY_WEEKLY_ON = exports.CREATE_FORM_FREQUENCY_WEEKLY = exports.CREATE_FORM_FREQUENCY_SUMMARY = exports.CREATE_FORM_FREQUENCY_NTH_WEEKDAY = exports.CREATE_FORM_FREQUENCY_MONTHLY = exports.CREATE_FORM_FREQUENCY_DAILY = exports.CREATE_FORM_FREQUENCY_CUSTOM = exports.CREATE_FORM_ENDS_ON_DATE = exports.CREATE_FORM_ENDS_NEVER = exports.CREATE_FORM_ENDS_AFTER_X = exports.CREATE_FORM_ENDS = exports.CREATE_FORM_CUSTOM_REPEAT_MONTHLY_ON_DAY = exports.CREATE_FORM_CUSTOM_FREQUENCY_YEARLY = exports.CREATE_FORM_CUSTOM_FREQUENCY_WEEKLY = exports.CREATE_FORM_CUSTOM_FREQUENCY_MONTHLY = exports.CREATE_FORM_CUSTOM_FREQUENCY_DAILY = exports.CREATE_FORM_COUNT_REQUIRED = exports.CREATE_FORM_COUNT_OCCURRENCE = exports.CREATE_FORM_COUNT_AFTER = exports.CREATE_FORM_CATEGORY_STACK_RULES = exports.CREATE_FORM_CATEGORY_SELECTION_TITLE = exports.CREATE_FORM_CATEGORY_SELECTION_DESCRIPTION = exports.CREATE_FORM_CATEGORY_SECURITY_RULES = exports.CREATE_FORM_CATEGORY_OBSERVABILITY_RULES = exports.CREATE_FORM_CATEGORY_IDS_REQUIRED = exports.CREATE_FORM_CATEGORIES_SELECTION_CHECKBOX_GROUP_TITLE = exports.CREATE_FORM_BYWEEKDAY_REQUIRED = exports.CANCEL_MODAL_TITLE = exports.CANCEL_MODAL_SUBTITLE = exports.CANCEL_MODAL_BUTTON = exports.CANCEL_AND_ARCHIVE_MODAL_TITLE = exports.CANCEL_AND_ARCHIVE_MODAL_SUBTITLE = exports.CANCEL = exports.ARCHIVE_TITLE = exports.ARCHIVE_SUBTITLE = exports.ARCHIVE_CALLOUT_SUBTITLE = exports.ARCHIVE = void 0;
var _i18n = require("@kbn/i18n");
var _rrule = require("@kbn/rrule");
var _month_day_date = require("./helpers/month_day_date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAINTENANCE_WINDOWS = _i18n.i18n.translate('xpack.alerting.maintenanceWindows', {
  defaultMessage: 'Maintenance Windows'
});
exports.MAINTENANCE_WINDOWS = MAINTENANCE_WINDOWS;
const MAINTENANCE_WINDOWS_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.description', {
  defaultMessage: 'Suppress rule notifications for scheduled periods of time.'
});
exports.MAINTENANCE_WINDOWS_DESCRIPTION = MAINTENANCE_WINDOWS_DESCRIPTION;
const READ_ONLY_BADGE_TEXT = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.badge.readOnly.text', {
  defaultMessage: 'Read only'
});
exports.READ_ONLY_BADGE_TEXT = READ_ONLY_BADGE_TEXT;
const READ_ONLY_BADGE_TOOLTIP = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.badge.readOnly.tooltip', {
  defaultMessage: 'Unable to create or edit maintenance Windows'
});
exports.READ_ONLY_BADGE_TOOLTIP = READ_ONLY_BADGE_TOOLTIP;
const CREATE_NEW_BUTTON = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createNewButton', {
  defaultMessage: 'Create window'
});
exports.CREATE_NEW_BUTTON = CREATE_NEW_BUTTON;
const EMPTY_PROMPT_BUTTON = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.emptyPrompt.button', {
  defaultMessage: 'Create a maintenance window'
});
exports.EMPTY_PROMPT_BUTTON = EMPTY_PROMPT_BUTTON;
const EMPTY_PROMPT_DOCUMENTATION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.emptyPrompt.documentation', {
  defaultMessage: 'Documentation'
});
exports.EMPTY_PROMPT_DOCUMENTATION = EMPTY_PROMPT_DOCUMENTATION;
const EMPTY_PROMPT_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.emptyPrompt.title', {
  defaultMessage: 'Create your first maintenance window'
});
exports.EMPTY_PROMPT_TITLE = EMPTY_PROMPT_TITLE;
const EMPTY_PROMPT_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.emptyPrompt.description', {
  defaultMessage: 'Schedule a time period in which rule notifications cease.'
});
exports.EMPTY_PROMPT_DESCRIPTION = EMPTY_PROMPT_DESCRIPTION;
const CREATE_MAINTENANCE_WINDOW = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.create.maintenanceWindow', {
  defaultMessage: 'Create maintenance window'
});
exports.CREATE_MAINTENANCE_WINDOW = CREATE_MAINTENANCE_WINDOW;
const CREATE_MAINTENANCE_WINDOW_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.create.description', {
  defaultMessage: 'Schedule a single or recurring period in which new alerts do not send notifications.'
});
exports.CREATE_MAINTENANCE_WINDOW_DESCRIPTION = CREATE_MAINTENANCE_WINDOW_DESCRIPTION;
const MAINTENANCE_WINDOWS_RETURN_LINK = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.returnLink', {
  defaultMessage: 'Return'
});
exports.MAINTENANCE_WINDOWS_RETURN_LINK = MAINTENANCE_WINDOWS_RETURN_LINK;
const NAME = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.name', {
  defaultMessage: 'Name'
});
exports.NAME = NAME;
const CREATE_FORM_NAME_REQUIRED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.nameFieldRequiredError', {
  defaultMessage: 'A name is required.'
});
exports.CREATE_FORM_NAME_REQUIRED = CREATE_FORM_NAME_REQUIRED;
const CREATE_FORM_SCHEDULE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.schedule', {
  defaultMessage: 'Schedule'
});
exports.CREATE_FORM_SCHEDULE = CREATE_FORM_SCHEDULE;
const CREATE_FORM_SCHEDULE_INVALID = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scheduleInvalid', {
  defaultMessage: 'The end date must be greater than or equal to the start date.'
});
exports.CREATE_FORM_SCHEDULE_INVALID = CREATE_FORM_SCHEDULE_INVALID;
const CREATE_FORM_TIMEZONE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.timezone', {
  defaultMessage: 'Time zone'
});
exports.CREATE_FORM_TIMEZONE = CREATE_FORM_TIMEZONE;
const CREATE_FORM_REPEAT = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.repeat', {
  defaultMessage: 'Repeat'
});
exports.CREATE_FORM_REPEAT = CREATE_FORM_REPEAT;
const CREATE_FORM_FREQUENCY_DAILY = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.daily', {
  defaultMessage: 'Daily'
});
exports.CREATE_FORM_FREQUENCY_DAILY = CREATE_FORM_FREQUENCY_DAILY;
const CREATE_FORM_FREQUENCY_WEEKLY = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.weekly', {
  defaultMessage: 'Weekly'
});
exports.CREATE_FORM_FREQUENCY_WEEKLY = CREATE_FORM_FREQUENCY_WEEKLY;
const CREATE_FORM_TIMEFRAME_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.title', {
  defaultMessage: 'Timeframe'
});
exports.CREATE_FORM_TIMEFRAME_TITLE = CREATE_FORM_TIMEFRAME_TITLE;
const CREATE_FORM_TIMEFRAME_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.description', {
  defaultMessage: 'Define the start and end time when events should be affected by the window.'
});
exports.CREATE_FORM_TIMEFRAME_DESCRIPTION = CREATE_FORM_TIMEFRAME_DESCRIPTION;
const CREATE_FORM_CATEGORY_IDS_REQUIRED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.categoryIds.required', {
  defaultMessage: 'A category is required.'
});
exports.CREATE_FORM_CATEGORY_IDS_REQUIRED = CREATE_FORM_CATEGORY_IDS_REQUIRED;
const CREATE_FORM_CATEGORY_SELECTION_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.categoriesSelection.title', {
  defaultMessage: 'Category specific maintenance window'
});
exports.CREATE_FORM_CATEGORY_SELECTION_TITLE = CREATE_FORM_CATEGORY_SELECTION_TITLE;
const CREATE_FORM_CATEGORY_SELECTION_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.categoriesSelection.description', {
  defaultMessage: 'Only rules associated with the selected categories are affected by the maintenance window.'
});
exports.CREATE_FORM_CATEGORY_SELECTION_DESCRIPTION = CREATE_FORM_CATEGORY_SELECTION_DESCRIPTION;
const CREATE_FORM_CATEGORIES_SELECTION_CHECKBOX_GROUP_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.categorySelection.checkboxGroupTitle', {
  defaultMessage: 'Select the categories this should affect'
});
exports.CREATE_FORM_CATEGORIES_SELECTION_CHECKBOX_GROUP_TITLE = CREATE_FORM_CATEGORIES_SELECTION_CHECKBOX_GROUP_TITLE;
const CREATE_FORM_CATEGORY_OBSERVABILITY_RULES = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.categoryIds.observabilityRules', {
  defaultMessage: 'Observability rules'
});
exports.CREATE_FORM_CATEGORY_OBSERVABILITY_RULES = CREATE_FORM_CATEGORY_OBSERVABILITY_RULES;
const CREATE_FORM_CATEGORY_SECURITY_RULES = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.categoryIds.securityRules', {
  defaultMessage: 'Security rules'
});
exports.CREATE_FORM_CATEGORY_SECURITY_RULES = CREATE_FORM_CATEGORY_SECURITY_RULES;
const CREATE_FORM_CATEGORY_STACK_RULES = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.categoryIds.stackRules', {
  defaultMessage: 'Stack rules'
});
exports.CREATE_FORM_CATEGORY_STACK_RULES = CREATE_FORM_CATEGORY_STACK_RULES;
const CREATE_FORM_SCOPED_QUERY_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scopedQuery.title', {
  defaultMessage: 'Filters'
});
exports.CREATE_FORM_SCOPED_QUERY_TITLE = CREATE_FORM_SCOPED_QUERY_TITLE;
const CREATE_FORM_SCOPED_QUERY_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scopedQuery.description', {
  defaultMessage: 'Add filters that refine the scope of the maintenance window. You can select only one category when filters are enabled.'
});
exports.CREATE_FORM_SCOPED_QUERY_DESCRIPTION = CREATE_FORM_SCOPED_QUERY_DESCRIPTION;
const CREATE_FORM_SCOPED_QUERY_TOGGLE_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scopedQuery.toggleTitle', {
  defaultMessage: 'Filter alerts'
});
exports.CREATE_FORM_SCOPED_QUERY_TOGGLE_TITLE = CREATE_FORM_SCOPED_QUERY_TOGGLE_TITLE;
const CREATE_FORM_SCOPED_QUERY_INVALID_ERROR_MESSAGE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scopedQuery.invalidErrorMessage', {
  defaultMessage: 'Invalid scoped query.'
});
exports.CREATE_FORM_SCOPED_QUERY_INVALID_ERROR_MESSAGE = CREATE_FORM_SCOPED_QUERY_INVALID_ERROR_MESSAGE;
const CREATE_FORM_SCOPED_QUERY_EMPTY_ERROR_MESSAGE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.scopedQuery.emptyErrorMessage', {
  defaultMessage: 'Scoped query is required.'
});
exports.CREATE_FORM_SCOPED_QUERY_EMPTY_ERROR_MESSAGE = CREATE_FORM_SCOPED_QUERY_EMPTY_ERROR_MESSAGE;
const CREATE_FORM_FREQUENCY_WEEKLY_ON = dayOfWeek => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.weeklyOnWeekday', {
  defaultMessage: 'Weekly on {dayOfWeek}',
  values: {
    dayOfWeek
  }
});
exports.CREATE_FORM_FREQUENCY_WEEKLY_ON = CREATE_FORM_FREQUENCY_WEEKLY_ON;
const CREATE_FORM_FREQUENCY_MONTHLY = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.monthly', {
  defaultMessage: 'Monthly'
});
exports.CREATE_FORM_FREQUENCY_MONTHLY = CREATE_FORM_FREQUENCY_MONTHLY;
const CREATE_FORM_FREQUENCY_NTH_WEEKDAY = dayOfWeek => [_i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.last', {
  defaultMessage: 'Monthly on the last {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.first', {
  defaultMessage: 'Monthly on the first {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.second', {
  defaultMessage: 'Monthly on the second {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.third', {
  defaultMessage: 'Monthly on the third {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.fourth', {
  defaultMessage: 'Monthly on the fourth {dayOfWeek}',
  values: {
    dayOfWeek
  }
})];
exports.CREATE_FORM_FREQUENCY_NTH_WEEKDAY = CREATE_FORM_FREQUENCY_NTH_WEEKDAY;
const CREATE_FORM_FREQUENCY_YEARLY = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.yearly', {
  defaultMessage: 'Yearly'
});
exports.CREATE_FORM_FREQUENCY_YEARLY = CREATE_FORM_FREQUENCY_YEARLY;
const CREATE_FORM_FREQUENCY_YEARLY_ON = startDate => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.yearlyOn', {
  defaultMessage: 'Yearly on {date}',
  values: {
    date: (0, _month_day_date.monthDayDate)(startDate)
  }
});
exports.CREATE_FORM_FREQUENCY_YEARLY_ON = CREATE_FORM_FREQUENCY_YEARLY_ON;
const CREATE_FORM_FREQUENCY_CUSTOM = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.frequency.custom', {
  defaultMessage: 'Custom'
});
exports.CREATE_FORM_FREQUENCY_CUSTOM = CREATE_FORM_FREQUENCY_CUSTOM;
const CREATE_FORM_ENDS = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.endsLabel', {
  defaultMessage: 'End'
});
exports.CREATE_FORM_ENDS = CREATE_FORM_ENDS;
const CREATE_FORM_ENDS_NEVER = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.ends.never', {
  defaultMessage: 'Never'
});
exports.CREATE_FORM_ENDS_NEVER = CREATE_FORM_ENDS_NEVER;
const CREATE_FORM_ENDS_ON_DATE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.ends.onDate', {
  defaultMessage: 'On date'
});
exports.CREATE_FORM_ENDS_ON_DATE = CREATE_FORM_ENDS_ON_DATE;
const CREATE_FORM_ENDS_AFTER_X = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.ends.afterX', {
  defaultMessage: 'After \\{x\\}'
});
exports.CREATE_FORM_ENDS_AFTER_X = CREATE_FORM_ENDS_AFTER_X;
const CREATE_FORM_COUNT_AFTER = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.count.after', {
  defaultMessage: 'After'
});
exports.CREATE_FORM_COUNT_AFTER = CREATE_FORM_COUNT_AFTER;
const CREATE_FORM_COUNT_OCCURRENCE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.count.occurrence', {
  defaultMessage: 'occurrence'
});
exports.CREATE_FORM_COUNT_OCCURRENCE = CREATE_FORM_COUNT_OCCURRENCE;
const CREATE_FORM_COUNT_REQUIRED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.countFieldRequiredError', {
  defaultMessage: 'A count is required.'
});
exports.CREATE_FORM_COUNT_REQUIRED = CREATE_FORM_COUNT_REQUIRED;
const CREATE_FORM_INTERVAL_REQUIRED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.intervalFieldRequiredError', {
  defaultMessage: 'An interval is required.'
});
exports.CREATE_FORM_INTERVAL_REQUIRED = CREATE_FORM_INTERVAL_REQUIRED;
const CREATE_FORM_INTERVAL_EVERY = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.interval.every', {
  defaultMessage: 'Every'
});
exports.CREATE_FORM_INTERVAL_EVERY = CREATE_FORM_INTERVAL_EVERY;
const CREATE_FORM_CUSTOM_FREQUENCY_DAILY = interval => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.customFrequency.daily', {
  defaultMessage: '{interval, plural, one {day} other {days}}',
  values: {
    interval
  }
});
exports.CREATE_FORM_CUSTOM_FREQUENCY_DAILY = CREATE_FORM_CUSTOM_FREQUENCY_DAILY;
const CREATE_FORM_CUSTOM_FREQUENCY_WEEKLY = interval => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.customFrequency.weekly', {
  defaultMessage: '{interval, plural, one {week} other {weeks}}',
  values: {
    interval
  }
});
exports.CREATE_FORM_CUSTOM_FREQUENCY_WEEKLY = CREATE_FORM_CUSTOM_FREQUENCY_WEEKLY;
const CREATE_FORM_CUSTOM_FREQUENCY_MONTHLY = interval => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.customFrequency.monthly', {
  defaultMessage: '{interval, plural, one {month} other {months}}',
  values: {
    interval
  }
});
exports.CREATE_FORM_CUSTOM_FREQUENCY_MONTHLY = CREATE_FORM_CUSTOM_FREQUENCY_MONTHLY;
const CREATE_FORM_CUSTOM_FREQUENCY_YEARLY = interval => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.customFrequency.yearly', {
  defaultMessage: '{interval, plural, one {year} other {years}}',
  values: {
    interval
  }
});
exports.CREATE_FORM_CUSTOM_FREQUENCY_YEARLY = CREATE_FORM_CUSTOM_FREQUENCY_YEARLY;
const CREATE_FORM_WEEKDAY_SHORT = dayOfWeek => [_i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.lastShort', {
  defaultMessage: 'On the last {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.firstShort', {
  defaultMessage: 'On the 1st {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.secondShort', {
  defaultMessage: 'On the 2nd {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.thirdShort', {
  defaultMessage: 'On the 3rd {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.fourthShort', {
  defaultMessage: 'On the 4th {dayOfWeek}',
  values: {
    dayOfWeek
  }
})];
exports.CREATE_FORM_WEEKDAY_SHORT = CREATE_FORM_WEEKDAY_SHORT;
const CREATE_FORM_BYWEEKDAY_REQUIRED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.byweekdayFieldRequiredError', {
  defaultMessage: 'A week day is required.'
});
exports.CREATE_FORM_BYWEEKDAY_REQUIRED = CREATE_FORM_BYWEEKDAY_REQUIRED;
const CREATE_FORM_CUSTOM_REPEAT_MONTHLY_ON_DAY = startDate => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.repeatOnMonthlyDay', {
  defaultMessage: 'On day {dayNumber}',
  values: {
    dayNumber: startDate.date()
  }
});
exports.CREATE_FORM_CUSTOM_REPEAT_MONTHLY_ON_DAY = CREATE_FORM_CUSTOM_REPEAT_MONTHLY_ON_DAY;
const CREATE_FORM_RECURRING_SUMMARY_PREFIX = summary => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.recurringSummaryPrefix', {
  defaultMessage: 'Repeats {summary}',
  values: {
    summary
  }
});
exports.CREATE_FORM_RECURRING_SUMMARY_PREFIX = CREATE_FORM_RECURRING_SUMMARY_PREFIX;
const CREATE_FORM_FREQUENCY_SUMMARY = interval => ({
  [_rrule.Frequency.DAILY]: _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.daySummary', {
    defaultMessage: '{interval, plural, one {day} other {# days}}',
    values: {
      interval
    }
  }),
  [_rrule.Frequency.WEEKLY]: _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.weekSummary', {
    defaultMessage: '{interval, plural, one {week} other {# weeks}}',
    values: {
      interval
    }
  }),
  [_rrule.Frequency.MONTHLY]: _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.monthSummary', {
    defaultMessage: '{interval, plural, one {month} other {# months}}',
    values: {
      interval
    }
  }),
  [_rrule.Frequency.YEARLY]: _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.yearSummary', {
    defaultMessage: '{interval, plural, one {year} other {# years}}',
    values: {
      interval
    }
  })
});
exports.CREATE_FORM_FREQUENCY_SUMMARY = CREATE_FORM_FREQUENCY_SUMMARY;
const CREATE_FORM_UNTIL_DATE_SUMMARY = date => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.untilDateSummary', {
  defaultMessage: 'until {date}',
  values: {
    date
  }
});
exports.CREATE_FORM_UNTIL_DATE_SUMMARY = CREATE_FORM_UNTIL_DATE_SUMMARY;
const CREATE_FORM_OCURRENCES_SUMMARY = count => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.occurrencesSummary', {
  defaultMessage: 'for {count, plural, one {# occurrence} other {# occurrences}}',
  values: {
    count
  }
});
exports.CREATE_FORM_OCURRENCES_SUMMARY = CREATE_FORM_OCURRENCES_SUMMARY;
const CREATE_FORM_RECURRING_SUMMARY = (frequencySummary, onSummary, untilSummary) => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.recurrenceSummary', {
  defaultMessage: 'every {frequencySummary}{on}{until}',
  values: {
    frequencySummary: frequencySummary ? `${frequencySummary} ` : '',
    on: onSummary ? `${onSummary} ` : '',
    until: untilSummary ? `${untilSummary}` : ''
  }
});
exports.CREATE_FORM_RECURRING_SUMMARY = CREATE_FORM_RECURRING_SUMMARY;
const CREATE_FORM_WEEKLY_SUMMARY = weekdays => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.weeklySummary', {
  defaultMessage: 'on {weekdays}',
  values: {
    weekdays
  }
});
exports.CREATE_FORM_WEEKLY_SUMMARY = CREATE_FORM_WEEKLY_SUMMARY;
const CREATE_FORM_MONTHLY_BY_DAY_SUMMARY = monthday => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.monthlyByDaySummary', {
  defaultMessage: 'on day {monthday}',
  values: {
    monthday
  }
});
exports.CREATE_FORM_MONTHLY_BY_DAY_SUMMARY = CREATE_FORM_MONTHLY_BY_DAY_SUMMARY;
const CREATE_FORM_YEARLY_BY_MONTH_SUMMARY = date => _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.yearlyBymonthSummary', {
  defaultMessage: 'on {date}',
  values: {
    date
  }
});
exports.CREATE_FORM_YEARLY_BY_MONTH_SUMMARY = CREATE_FORM_YEARLY_BY_MONTH_SUMMARY;
const CANCEL = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.createForm.cancel', {
  defaultMessage: 'Cancel'
});
exports.CANCEL = CANCEL;
const TABLE_ALERTS = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.alerts', {
  defaultMessage: 'Alerts'
});

// Add this tooltip to the Alerts column heading on the MW table
exports.TABLE_ALERTS = TABLE_ALERTS;
const TABLE_ALERTS_TOOLTIP = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.alertsTooltip', {
  defaultMessage: 'The total number of alerts created in the maintenance window.'
});
exports.TABLE_ALERTS_TOOLTIP = TABLE_ALERTS_TOOLTIP;
const TABLE_STATUS = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.status', {
  defaultMessage: 'Status'
});
exports.TABLE_STATUS = TABLE_STATUS;
const TABLE_STATUS_RUNNING = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.statusRunning', {
  defaultMessage: 'Running'
});
exports.TABLE_STATUS_RUNNING = TABLE_STATUS_RUNNING;
const TABLE_STATUS_UPCOMING = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.statusUpcoming', {
  defaultMessage: 'Upcoming'
});
exports.TABLE_STATUS_UPCOMING = TABLE_STATUS_UPCOMING;
const TABLE_STATUS_FINISHED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.statusFinished', {
  defaultMessage: 'Finished'
});
exports.TABLE_STATUS_FINISHED = TABLE_STATUS_FINISHED;
const TABLE_STATUS_ARCHIVED = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.statusArchived', {
  defaultMessage: 'Archived'
});
exports.TABLE_STATUS_ARCHIVED = TABLE_STATUS_ARCHIVED;
const TABLE_START_TIME = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.startTime', {
  defaultMessage: 'Start time'
});
exports.TABLE_START_TIME = TABLE_START_TIME;
const TABLE_END_TIME = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.endTime', {
  defaultMessage: 'End time'
});
exports.TABLE_END_TIME = TABLE_END_TIME;
const TABLE_ACTION_EDIT = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.edit', {
  defaultMessage: 'Edit'
});
exports.TABLE_ACTION_EDIT = TABLE_ACTION_EDIT;
const EDIT_MAINTENANCE_WINDOW = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.edit.maintenanceWindow', {
  defaultMessage: 'Edit maintenance window'
});
exports.EDIT_MAINTENANCE_WINDOW = EDIT_MAINTENANCE_WINDOW;
const SAVE_MAINTENANCE_WINDOW = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.save.maintenanceWindow', {
  defaultMessage: 'Save maintenance window'
});
exports.SAVE_MAINTENANCE_WINDOW = SAVE_MAINTENANCE_WINDOW;
const TABLE_ACTION_CANCEL = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.cancel', {
  defaultMessage: 'Cancel'
});
exports.TABLE_ACTION_CANCEL = TABLE_ACTION_CANCEL;
const CANCEL_MODAL_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.cancelModal.title', {
  defaultMessage: 'Cancel maintenance window'
});
exports.CANCEL_MODAL_TITLE = CANCEL_MODAL_TITLE;
const CANCEL_MODAL_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.cancelModal.subtitle', {
  defaultMessage: 'Rule notifications resume immediately. Running maintenance window events are canceled; upcoming events are unaffected.'
});
exports.CANCEL_MODAL_SUBTITLE = CANCEL_MODAL_SUBTITLE;
const CANCEL_MODAL_BUTTON = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.cancelModal.button', {
  defaultMessage: 'Keep running'
});
exports.CANCEL_MODAL_BUTTON = CANCEL_MODAL_BUTTON;
const TABLE_ACTION_CANCEL_AND_ARCHIVE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.cancelAndArchive', {
  defaultMessage: 'Cancel and archive'
});
exports.TABLE_ACTION_CANCEL_AND_ARCHIVE = TABLE_ACTION_CANCEL_AND_ARCHIVE;
const CANCEL_AND_ARCHIVE_MODAL_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.cancelAndArchiveModal.title', {
  defaultMessage: 'Cancel and archive maintenance window'
});
exports.CANCEL_AND_ARCHIVE_MODAL_TITLE = CANCEL_AND_ARCHIVE_MODAL_TITLE;
const CANCEL_AND_ARCHIVE_MODAL_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.cancelAndArchiveModal.subtitle', {
  defaultMessage: 'Rule notifications resume immediately. All running and upcoming maintenance window events are canceled and the window is queued for deletion.'
});
exports.CANCEL_AND_ARCHIVE_MODAL_SUBTITLE = CANCEL_AND_ARCHIVE_MODAL_SUBTITLE;
const ARCHIVE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.archive', {
  defaultMessage: 'Archive'
});
exports.ARCHIVE = ARCHIVE;
const ARCHIVE_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.archive.title', {
  defaultMessage: 'Archive maintenance window'
});
exports.ARCHIVE_TITLE = ARCHIVE_TITLE;
const ARCHIVE_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.archive.subtitle', {
  defaultMessage: 'Upcoming maintenance window events are canceled and the window is queued for deletion.'
});
exports.ARCHIVE_SUBTITLE = ARCHIVE_SUBTITLE;
const TABLE_ACTION_UNARCHIVE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.table.unarchive', {
  defaultMessage: 'Unarchive'
});
exports.TABLE_ACTION_UNARCHIVE = TABLE_ACTION_UNARCHIVE;
const UNARCHIVE_MODAL_TITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.unarchiveModal.title', {
  defaultMessage: 'Unarchive maintenance window'
});
exports.UNARCHIVE_MODAL_TITLE = UNARCHIVE_MODAL_TITLE;
const UNARCHIVE_MODAL_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.unarchiveModal.subtitle', {
  defaultMessage: 'Upcoming maintenance window events are scheduled.'
});
exports.UNARCHIVE_MODAL_SUBTITLE = UNARCHIVE_MODAL_SUBTITLE;
const ARCHIVE_CALLOUT_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.archiveCallout.subtitle', {
  defaultMessage: 'The changes you have made here will not be saved. Are you sure you want to discard these unsaved changes and archive this maintenance window?'
});
exports.ARCHIVE_CALLOUT_SUBTITLE = ARCHIVE_CALLOUT_SUBTITLE;
const EXPERIMENTAL_LABEL = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.badge.experimentalLabel', {
  defaultMessage: 'Technical preview'
});
exports.EXPERIMENTAL_LABEL = EXPERIMENTAL_LABEL;
const EXPERIMENTAL_DESCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.badge.experimentalDescription', {
  defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
});
exports.EXPERIMENTAL_DESCRIPTION = EXPERIMENTAL_DESCRIPTION;
const UPCOMING = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.upcoming', {
  defaultMessage: 'Upcoming'
});
exports.UPCOMING = UPCOMING;
const UPGRADE_TO_PLATINUM = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.licenseCallout.updgradeToPlatinumTitle', {
  defaultMessage: 'Maintenance windows are a subscription feature'
});
exports.UPGRADE_TO_PLATINUM = UPGRADE_TO_PLATINUM;
const UPGRADE_TO_PLATINUM_SUBTITLE = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.licenseCallout.upgradeToPlatinumSubtitle', {
  defaultMessage: 'Select an option to unlock it.'
});
exports.UPGRADE_TO_PLATINUM_SUBTITLE = UPGRADE_TO_PLATINUM_SUBTITLE;
const UPGRADE_SUBSCRIPTION = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.licenseCallout.upgradeSubscription', {
  defaultMessage: 'Upgrade subscription'
});
exports.UPGRADE_SUBSCRIPTION = UPGRADE_SUBSCRIPTION;
const START_TRIAL = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.licenseCallout.startTrial', {
  defaultMessage: 'Start trial'
});
exports.START_TRIAL = START_TRIAL;
const REFRESH = _i18n.i18n.translate('xpack.alerting.maintenanceWindows.refreshButton', {
  defaultMessage: 'Refresh'
});
exports.REFRESH = REFRESH;