"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpcomingEventsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _common = require("../../../../common");
var _recurring_summary = require("../helpers/recurring_summary");
var _get_presets = require("../helpers/get_presets");
var _convert_from_maintenance_window_to_form = require("../helpers/convert_from_maintenance_window_to_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpcomingEventsPopover = /*#__PURE__*/_react.default.memo(({
  maintenanceWindowFindResponse
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(open => !open);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const {
    startDate,
    recurringSchedule,
    topEvents,
    presets
  } = (0, _react.useMemo)(() => {
    const maintenanceWindow = (0, _convert_from_maintenance_window_to_form.convertFromMaintenanceWindowToForm)(maintenanceWindowFindResponse);
    const date = (0, _moment.default)(maintenanceWindow.startDate);
    const currentEventIndex = (0, _lodash.findIndex)(maintenanceWindowFindResponse.events, event => event.gte === maintenanceWindowFindResponse.eventStartTime && event.lte === maintenanceWindowFindResponse.eventEndTime);
    return {
      startDate: date,
      recurringSchedule: maintenanceWindow.recurringSchedule,
      topEvents: maintenanceWindowFindResponse.events.slice(currentEventIndex + 1, currentEventIndex + 4),
      presets: (0, _get_presets.getPresets)(date)
    };
  }, [maintenanceWindowFindResponse]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "upcoming-events-icon-button",
      color: "text",
      display: "base",
      iconType: "calendar",
      size: "s",
      "aria-label": "Upcoming events",
      onClick: onButtonClick
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    "data-test-subj": "upcoming-events-popover-title"
  }, i18n.CREATE_FORM_RECURRING_SUMMARY_PREFIX((0, _recurring_summary.recurringSummary)(startDate, recurringSchedule, presets))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      fontWeight: 700
    },
    color: "subdued",
    size: "s"
  }, i18n.UPCOMING), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), topEvents.map((event, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "upcoming-events-popover-item",
    key: `startDate.${index}`,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    justifyContent: "flexStart",
    style: {
      width: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "calendar"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, (0, _eui.formatDate)(event.gte, _common.MAINTENANCE_WINDOW_DATE_FORMAT)))), index < topEvents.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    style: {
      inlineSize: 'unset',
      marginInline: '-16px'
    },
    margin: "s"
  }) : null))));
});
exports.UpcomingEventsPopover = UpcomingEventsPopover;
UpcomingEventsPopover.displayName = 'UpcomingEventsPopover';