"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateMaintenanceWindow = useCreateMaintenanceWindow;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
var _create = require("../services/maintenance_windows_api/create");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCreateMaintenanceWindow(props) {
  const {
    onError
  } = props || {};
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const mutationFn = maintenanceWindow => {
    return (0, _create.createMaintenanceWindow)({
      http,
      maintenanceWindow
    });
  };
  return (0, _reactQuery.useMutation)(mutationFn, {
    onSuccess: data => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.alerting.maintenanceWindowsCreateSuccess', {
        defaultMessage: "Created maintenance window '{title}'",
        values: {
          title: data.title
        }
      }));
    },
    onError: error => {
      toasts.addDanger(_i18n.i18n.translate('xpack.alerting.maintenanceWindowsCreateFailure', {
        defaultMessage: 'Failed to create maintenance window.'
      }));
      onError === null || onError === void 0 ? void 0 : onError(error);
    }
  });
}