"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_CHANGE_POINT_CHARTS_ACTION = void 0;
exports.createEditChangePointChartsPanelAction = createEditChangePointChartsPanelAction;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/embeddable-plugin/common");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const EDIT_CHANGE_POINT_CHARTS_ACTION = 'editChangePointChartsPanelAction';
exports.EDIT_CHANGE_POINT_CHARTS_ACTION = EDIT_CHANGE_POINT_CHARTS_ACTION;
function createEditChangePointChartsPanelAction(coreStart, pluginStart) {
  return {
    id: 'edit-change-point-charts',
    type: EDIT_CHANGE_POINT_CHARTS_ACTION,
    getIconType(context) {
      return 'pencil';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.aiops.actions.editChangePointChartsName', {
      defaultMessage: 'Edit change point charts'
    }),
    async execute({
      embeddable
    }) {
      if (!embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      try {
        const {
          resolveEmbeddableChangePointUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddable/handle_explicit_input')));
        const result = await resolveEmbeddableChangePointUserInput(coreStart, pluginStart, embeddable.getInput());
        embeddable.updateInput(result);
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible({
      embeddable
    }) {
      return embeddable.type === _constants.EMBEDDABLE_CHANGE_POINT_CHART_TYPE && embeddable.getInput().viewMode === _common.ViewMode.EDIT;
    }
  };
}