"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilerQueryUpdates = exports.FilterQueryContextProvider = exports.FilterQueryContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _use_aiops_app_context = require("./use_aiops_app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterQueryContext = /*#__PURE__*/(0, _react.createContext)({
  get filters() {
    throw new Error('FilterQueryContext is not initialized');
  },
  get query() {
    throw new Error('FilterQueryContext is not initialized');
  },
  get timeRange() {
    throw new Error('FilterQueryContext is not initialized');
  }
});

/**
 * Helper context to provide the latest filter, query and time range values
 * from the data plugin.
 * Also merges custom filters and queries provided with an input.
 *
 * @param children
 * @constructor
 */
exports.FilterQueryContext = FilterQueryContext;
const FilterQueryContextProvider = ({
  children,
  timeRange
}) => {
  const {
    data: {
      query: {
        filterManager,
        queryString
      }
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const [resultFilters, setResultFilter] = (0, _react.useState)(filterManager.getFilters());
  const [resultQuery, setResultQuery] = (0, _react.useState)(queryString.getQuery());
  const timeRangeUpdates = (0, _mlDatePicker.useTimeRangeUpdates)(false);
  (0, _react.useEffect)(() => {
    const sub = filterManager.getUpdates$().subscribe(() => {
      setResultFilter(filterManager.getFilters());
    });
    return () => {
      sub.unsubscribe();
    };
  }, [filterManager]);
  (0, _react.useEffect)(() => {
    const sub = queryString.getUpdates$().subscribe(() => {
      setResultQuery(queryString.getQuery());
    });
    return () => {
      sub.unsubscribe();
    };
  }, [queryString]);
  return /*#__PURE__*/_react.default.createElement(FilterQueryContext.Provider, {
    value: {
      filters: resultFilters,
      query: resultQuery,
      timeRange: timeRange !== null && timeRange !== void 0 ? timeRange : timeRangeUpdates
    }
  }, children);
};
exports.FilterQueryContextProvider = FilterQueryContextProvider;
const useFilerQueryUpdates = () => {
  return (0, _react.useContext)(FilterQueryContext);
};
exports.useFilerQueryUpdates = useFilerQueryUpdates;