"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceContextProvider = exports.DataSourceContext = void 0;
exports.useDataSource = useDataSource;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_aiops_app_context = require("./use_aiops_app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataSourceContext = /*#__PURE__*/(0, _react.createContext)({
  get dataView() {
    throw new Error('DataSourceContext is not implemented');
  },
  savedSearch: null
});
exports.DataSourceContext = DataSourceContext;
function useDataSource() {
  return (0, _react.useContext)(DataSourceContext);
}
/**
 * Context provider that resolves current data view and the saved search
 *
 * @param children
 * @constructor
 */
const DataSourceContextProvider = ({
  dataViewId,
  savedSearchId,
  children,
  onChange
}) => {
  const [value, setValue] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  const {
    data: {
      dataViews
    }
    // uiSettings,
    // savedSearch: savedSearchService,
  } = (0, _use_aiops_app_context.useAiopsAppContext)();

  /**
   * Resolve data view or saved search if exists.
   */
  const resolveDataSource = (0, _react.useCallback)(async () => {
    const dataViewAndSavedSearch = {
      savedSearch: null,
      // @ts-ignore
      dataView: null
    };

    // support only data views for now
    if (dataViewId) {
      dataViewAndSavedSearch.dataView = await dataViews.get(dataViewId);
    }
    const {
      savedSearch,
      dataView
    } = dataViewAndSavedSearch;
    return {
      dataView,
      savedSearch
    };
  }, [dataViewId, dataViews]);
  (0, _react.useEffect)(() => {
    resolveDataSource().then(result => {
      setError(undefined);
      setValue(result);
      if (onChange) {
        onChange({
          dataViews: [result.dataView]
        });
      }
    }).catch(e => {
      setError(e);
    });
  }, [resolveDataSource, onChange, dataViewId]);
  if ((!value || !(value !== null && value !== void 0 && value.dataView)) && !error) return null;
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.dataSourceContext.errorTitle",
        defaultMessage: "Unable to fetch data view or saved search"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, error.message)
    });
  }
  return /*#__PURE__*/_react.default.createElement(DataSourceContext.Provider, {
    value: value
  }, children);
};
exports.DataSourceContextProvider = DataSourceContextProvider;