"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useViewInLogPatternAnalysisAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _table_action_button = require("./table_action_button");
var _get_table_item_as_kql = require("./get_table_item_as_kql");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isLogPattern = tableItem => (0, _mlAggUtils.isSignificantItem)(tableItem) && tableItem.type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.LOG_PATTERN;
const viewInLogPatternAnalysisMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.linksMenu.viewInLogPatternAnalysis', {
  defaultMessage: 'View in Log Pattern Analysis'
});
const useViewInLogPatternAnalysisAction = dataViewId => {
  const {
    application,
    share,
    data
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const mlLocator = (0, _react.useMemo)(() => share.url.locators.get('ML_APP_LOCATOR'), [share.url.locators]);
  const generateLogPatternAnalysisUrl = async groupTableItem => {
    if (mlLocator !== undefined) {
      const searchString = (0, _get_table_item_as_kql.getTableItemAsKQL)(groupTableItem);
      const ast = (0, _esQuery.fromKueryExpression)(searchString);
      const searchQuery = (0, _esQuery.toElasticsearchQuery)(ast);
      const appState = {
        logCategorization: {
          filters: data.query.filterManager.getFilters(),
          // QueryDslQueryContainer type triggers an error as being
          // not working with SerializableRecord, however, it works as expected.
          searchQuery: searchQuery,
          searchQueryLanguage: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
          searchString: (0, _get_table_item_as_kql.getTableItemAsKQL)(groupTableItem)
        }
      };
      return await mlLocator.getUrl({
        page: 'aiops/log_categorization',
        pageState: {
          index: dataViewId,
          timeRange: data.query.timefilter.timefilter.getTime(),
          appState
        }
      });
    }
  };
  const logPatternAnalysisUrlError = (0, _react.useMemo)(() => {
    if (!mlLocator) {
      return _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.mlLocatorMissingErrorMessage', {
        defaultMessage: 'No locator for Log Pattern Analysis detected'
      });
    }
    if (!dataViewId) {
      return _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.autoGeneratedLogPatternAnalysisLinkErrorMessage', {
        defaultMessage: 'Unable to link to Log Pattern Analysis; no data view exists for this index'
      });
    }
  }, [dataViewId, mlLocator]);
  return {
    render: tableItem => {
      const message = logPatternAnalysisUrlError ? logPatternAnalysisUrlError : viewInLogPatternAnalysisMessage;
      const clickHandler = async () => {
        if (!isLogPattern(tableItem)) {
          const openInLogPatternAnalysisUrl = await generateLogPatternAnalysisUrl(tableItem);
          if (typeof openInLogPatternAnalysisUrl === 'string') {
            await application.navigateToUrl(openInLogPatternAnalysisUrl);
          }
        }
      };
      const isDisabled = logPatternAnalysisUrlError !== undefined || isLogPattern(tableItem);
      return /*#__PURE__*/_react.default.createElement(_table_action_button.TableActionButton, {
        dataTestSubjPostfix: "LogPatternAnalysis",
        iconType: "logstashQueue",
        isDisabled: isDisabled,
        label: viewInLogPatternAnalysisMessage,
        tooltipText: !isLogPattern(tableItem) ? message : _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.logPatternLinkNotAvailableTooltipMessage', {
          defaultMessage: 'This link is not available if the table item is a log pattern itself.'
        }),
        onClick: clickHandler
      });
    }
  };
};
exports.useViewInLogPatternAnalysisAction = useViewInLogPatternAnalysisAction;