"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilter = createFilter;
exports.useDiscoverLinks = useDiscoverLinks;
var _moment = _interopRequireDefault(require("moment"));
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _i18n = require("@kbn/i18n");
var _get_category_query = require("../../../common/api/log_categorization/get_category_query");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDiscoverLinks() {
  const {
    http: {
      basePath
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const openInDiscoverWithFilter = (index, field, selection, aiopsListState, timefilterActiveBounds, mode, category, additionalField) => {
    var _timefilterActiveBoun, _timefilterActiveBoun2;
    const _g = _rison.default.encode({
      time: {
        from: (0, _moment.default)((_timefilterActiveBoun = timefilterActiveBounds.min) === null || _timefilterActiveBoun === void 0 ? void 0 : _timefilterActiveBoun.valueOf()).toISOString(),
        to: (0, _moment.default)((_timefilterActiveBoun2 = timefilterActiveBounds.max) === null || _timefilterActiveBoun2 === void 0 ? void 0 : _timefilterActiveBoun2.valueOf()).toISOString()
      }
    });
    const _a = _rison.default.encode({
      filters: [...aiopsListState.filters, createFilter(index, field, selection, mode, category, additionalField)],
      index,
      interval: 'auto',
      query: {
        language: aiopsListState.searchQueryLanguage,
        query: aiopsListState.searchString
      }
    });
    let path = basePath.get();
    path += '/app/discover#/';
    path += '?_g=' + _g;
    path += '&_a=' + encodeURIComponent(_a);
    window.open(path, '_blank');
  };
  return {
    openInDiscoverWithFilter
  };
}
function createFilter(index, field, selection, mode, category, additionalField) {
  const selectedRows = category === undefined ? selection : [category];
  const query = (0, _get_category_query.getCategoryQuery)(field, selectedRows, mode);
  if (additionalField !== undefined) {
    query.bool.must = [{
      term: {
        [additionalField.name]: additionalField.value
      }
    }];
  }
  return {
    query,
    meta: {
      alias: _i18n.i18n.translate('xpack.aiops.logCategorization.filterAliasLabel', {
        defaultMessage: 'Categorization - {field}',
        values: {
          field
        }
      }),
      index,
      disabled: false
    }
  };
}