"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _aiopsComponents = require("@kbn/aiops-components");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _total_count_header = require("../total_count_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentCountContent = ({
  brushSelectionUpdateHandler,
  documentCountStats,
  documentCountStatsSplit,
  documentCountStatsSplitLabel = '',
  isBrushCleared,
  totalCount,
  sampleProbability,
  initialAnalysisStart,
  barColorOverride,
  barHighlightColorOverride,
  windowParameters,
  incomingInitialAnalysisStart,
  ...docCountChartProps
}) => {
  var _documentCountStats$b, _documentCountStatsSp;
  const {
    data,
    uiSettings,
    fieldFormats,
    charts
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const bucketTimestamps = Object.keys((_documentCountStats$b = documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.buckets) !== null && _documentCountStats$b !== void 0 ? _documentCountStats$b : {}).map(time => +time);
  const splitBucketTimestamps = Object.keys((_documentCountStatsSp = documentCountStatsSplit === null || documentCountStatsSplit === void 0 ? void 0 : documentCountStatsSplit.buckets) !== null && _documentCountStatsSp !== void 0 ? _documentCountStatsSp : {}).map(time => +time);
  const timeRangeEarliest = Math.min(...[...bucketTimestamps, ...splitBucketTimestamps]);
  const timeRangeLatest = Math.max(...[...bucketTimestamps, ...splitBucketTimestamps]);
  if (documentCountStats === undefined || documentCountStats.buckets === undefined || timeRangeEarliest === undefined || timeRangeLatest === undefined) {
    return totalCount !== undefined ? /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
      totalCount: totalCount,
      sampleProbability: sampleProbability
    }) : null;
  }
  const chartPoints = Object.entries(documentCountStats.buckets).map(([time, value]) => ({
    time: +time,
    value
  }));
  let chartPointsSplit;
  if ((documentCountStatsSplit === null || documentCountStatsSplit === void 0 ? void 0 : documentCountStatsSplit.buckets) !== undefined) {
    chartPointsSplit = Object.entries(documentCountStatsSplit === null || documentCountStatsSplit === void 0 ? void 0 : documentCountStatsSplit.buckets).map(([time, value]) => ({
      time: +time,
      value
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount,
    sampleProbability: sampleProbability
  })), documentCountStats.interval !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_aiopsComponents.DocumentCountChart, (0, _extends2.default)({
    dependencies: {
      data,
      uiSettings,
      fieldFormats,
      charts
    },
    brushSelectionUpdateHandler: brushSelectionUpdateHandler,
    chartPoints: chartPoints,
    chartPointsSplit: chartPointsSplit,
    timeRangeEarliest: timeRangeEarliest,
    timeRangeLatest: timeRangeLatest,
    interval: documentCountStats.interval,
    chartPointsSplitLabel: documentCountStatsSplitLabel,
    isBrushCleared: isBrushCleared,
    autoAnalysisStart: initialAnalysisStart,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride
  }, docCountChartProps))));
};
exports.DocumentCountContent = DocumentCountContent;