"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RANDOM_SAMPLER_SEED = exports.LOG_RATE_ANALYSIS_SETTINGS = exports.EMBEDDABLE_ORIGIN = exports.EMBEDDABLE_CHANGE_POINT_CHART_TYPE = exports.CASES_ATTACHMENT_CHANGE_POINT_CHART = exports.AIOPS_TELEMETRY_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_RATE_ANALYSIS_SETTINGS = {
  /**
   * The p-value threshold to be used for statistically significant items.
   */
  P_VALUE_THRESHOLD: 0.02,
  /**
   * The minimum support value to be used for the frequent item sets aggration.
   */
  FREQUENT_ITEMS_SETS_MINIMUM_SUPPORT: 0.001
};

/**
 * For the technical preview of Log Rate Analysis we use a hard coded seed.
 * In future versions we might use a user specific seed or let the user customise it.
 */
exports.LOG_RATE_ANALYSIS_SETTINGS = LOG_RATE_ANALYSIS_SETTINGS;
const RANDOM_SAMPLER_SEED = 3867412;
exports.RANDOM_SAMPLER_SEED = RANDOM_SAMPLER_SEED;
const CASES_ATTACHMENT_CHANGE_POINT_CHART = 'aiopsChangePointChart';
exports.CASES_ATTACHMENT_CHANGE_POINT_CHART = CASES_ATTACHMENT_CHANGE_POINT_CHART;
const EMBEDDABLE_CHANGE_POINT_CHART_TYPE = 'aiopsChangePointChart';
exports.EMBEDDABLE_CHANGE_POINT_CHART_TYPE = EMBEDDABLE_CHANGE_POINT_CHART_TYPE;
const AIOPS_TELEMETRY_ID = {
  AIOPS_DEFAULT_SOURCE: 'ml_aiops_labs',
  AIOPS_ANALYSIS_RUN_ORIGIN: 'aiops-analysis-run-origin'
};
exports.AIOPS_TELEMETRY_ID = AIOPS_TELEMETRY_ID;
const EMBEDDABLE_ORIGIN = 'embeddable';
exports.EMBEDDABLE_ORIGIN = EMBEDDABLE_ORIGIN;