"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.API_ACTION_NAME = void 0;
exports.addErrorAction = addErrorAction;
exports.addSignificantItemsAction = addSignificantItemsAction;
exports.addSignificantItemsGroupAction = addSignificantItemsGroupAction;
exports.addSignificantItemsGroupHistogramAction = addSignificantItemsGroupHistogramAction;
exports.addSignificantItemsHistogramAction = addSignificantItemsHistogramAction;
exports.pingAction = pingAction;
exports.resetAllAction = resetAllAction;
exports.resetErrorsAction = resetErrorsAction;
exports.resetGroupsAction = resetGroupsAction;
exports.setZeroDocsFallback = setZeroDocsFallback;
exports.updateLoadingStateAction = updateLoadingStateAction;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_ACTION_NAME = {
  /** @since API v2 */
  ADD_SIGNIFICANT_ITEMS: 'add_significant_items',
  /** @since API v2 */
  ADD_SIGNIFICANT_ITEMS_HISTOGRAM: 'add_significant_items_histogram',
  /** @since API v2 */
  ADD_SIGNIFICANT_ITEMS_GROUP: 'add_significant_items_group',
  /** @since API v2 */
  ADD_SIGNIFICANT_ITEMS_GROUP_HISTOGRAM: 'add_significant_items_group_histogram',
  /** @deprecated since API v2 */
  ADD_SIGNIFICANT_TERMS: 'add_significant_terms',
  /** @deprecated since API v2 */
  ADD_SIGNIFICANT_TERMS_HISTOGRAM: 'add_significant_terms_histogram',
  /** @deprecated since API v2 */
  ADD_SIGNIFICANT_TERMS_GROUP: 'add_significant_terms_group',
  /** @deprecated since API v2 */
  ADD_SIGNIFICANT_TERMS_GROUP_HISTOGRAM: 'add_significant_terms_group_histogram',
  ADD_ERROR: 'add_error',
  PING: 'ping',
  RESET_ALL: 'reset_all',
  RESET_ERRORS: 'reset_errors',
  RESET_GROUPS: 'reset_groups',
  SET_ZERO_DOCS_FALLBACK: 'set_zero_docs_fallback',
  UPDATE_LOADING_STATE: 'update_loading_state'
};
exports.API_ACTION_NAME = API_ACTION_NAME;
function addSignificantItemsAction(payload, version) {
  if (version === '1') {
    return {
      type: API_ACTION_NAME.ADD_SIGNIFICANT_TERMS,
      payload
    };
  }
  return {
    type: API_ACTION_NAME.ADD_SIGNIFICANT_ITEMS,
    payload
  };
}
function addSignificantItemsHistogramAction(payload, version) {
  if (version === '1') {
    return {
      type: API_ACTION_NAME.ADD_SIGNIFICANT_TERMS_HISTOGRAM,
      payload
    };
  }
  return {
    type: API_ACTION_NAME.ADD_SIGNIFICANT_ITEMS_HISTOGRAM,
    payload
  };
}
function addSignificantItemsGroupAction(payload, version) {
  if (version === '1') {
    return {
      type: API_ACTION_NAME.ADD_SIGNIFICANT_TERMS_GROUP,
      payload
    };
  }
  return {
    type: API_ACTION_NAME.ADD_SIGNIFICANT_ITEMS_GROUP,
    payload
  };
}
function addSignificantItemsGroupHistogramAction(payload, version) {
  if (version === '1') {
    return {
      type: API_ACTION_NAME.ADD_SIGNIFICANT_TERMS_GROUP_HISTOGRAM,
      payload
    };
  }
  return {
    type: API_ACTION_NAME.ADD_SIGNIFICANT_ITEMS_GROUP_HISTOGRAM,
    payload
  };
}
function addErrorAction(payload) {
  return {
    type: API_ACTION_NAME.ADD_ERROR,
    payload
  };
}
function resetErrorsAction() {
  return {
    type: API_ACTION_NAME.RESET_ERRORS
  };
}
function pingAction() {
  return {
    type: API_ACTION_NAME.PING
  };
}
function resetAllAction() {
  return {
    type: API_ACTION_NAME.RESET_ALL
  };
}
function resetGroupsAction() {
  return {
    type: API_ACTION_NAME.RESET_GROUPS
  };
}
function updateLoadingStateAction(payload) {
  return {
    type: API_ACTION_NAME.UPDATE_LOADING_STATE,
    payload
  };
}
function setZeroDocsFallback(payload) {
  return {
    type: API_ACTION_NAME.SET_ZERO_DOCS_FALLBACK,
    payload
  };
}