"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseBulkImportFlyout = KnowledgeBaseBulkImportFlyout;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_import_knowledge_base_entries = require("../../hooks/use_import_knowledge_base_entries");
var _use_app_context = require("../../hooks/use_app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function KnowledgeBaseBulkImportFlyout({
  onClose
}) {
  const {
    notifications: {
      toasts
    }
  } = (0, _use_app_context.useAppContext)();
  const {
    mutateAsync,
    isLoading
  } = (0, _use_import_knowledge_base_entries.useImportKnowledgeBaseEntries)();
  const filePickerId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filePicker'
  });
  const [files, setFiles] = (0, _react.useState)([]);
  const onChange = file => {
    setFiles(file && file.length > 0 ? Array.from(file) : []);
  };
  const handleSubmitNewEntryClick = async () => {
    let entries = [];
    const text = await files[0].text();
    const elements = text.split('\n').filter(Boolean);
    try {
      entries = elements.map(el => JSON.parse(el));
    } catch (_) {
      toasts.addError(new Error(_i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseBulkImportFlyout.errorParsingEntries.description', {
        defaultMessage: 'Error parsing JSON entries'
      })), {
        title: _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseBulkImportFlyout.errorParsingEntries.title', {
          defaultMessage: 'Something went wrong'
        })
      });
    }
    mutateAsync({
      entries
    }).then(onClose);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "knowledgeBaseBulkImportFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseBulkImportFlyout.h2.bulkImportLabel', {
    defaultMessage: 'Import files'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "addDataApp",
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseBulkImportFlyout.addFilesToEnrichTitleLabel', {
    defaultMessage: 'Add files to enrich your Knowledge base'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "aiAssistantManagementObservability.knowledgeBaseBulkImportFlyout.uploadAJSONFileTextLabel",
    defaultMessage: "Upload a newline delimited JSON ({ext}) file containing a list of entries to add to your Knowledge base.",
    values: {
      ext: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        language: "html"
      }, ".ndjson")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseBulkImportFlyout.theObjectsShouldBeTextLabel', {
    defaultMessage: 'The objects should be of the following format:'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    paddingSize: "s"
  }, `{
  "id": "a_unique_human_readable_id",
  "text": "Contents of item",
}
`), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    "aria-label": _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseBulkImportFlyout.euiFilePicker.uploadJSONLabel', {
      defaultMessage: 'Upload JSON'
    }),
    display: "large",
    fullWidth: true,
    id: filePickerId,
    initialPromptText: _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseBulkImportFlyout.euiFilePicker.selectOrDragAndLabel', {
      defaultMessage: 'Select or drag and drop a .ndjson file'
    }),
    onChange: onChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "knowledgeBaseBulkImportFlyoutCancelButton",
    disabled: isLoading,
    onClick: onClose
  }, _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseBulkImportFlyout.cancelButtonEmptyLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "knowledgeBaseBulkImportFlyoutSaveButton",
    fill: true,
    isLoading: isLoading,
    onClick: handleSubmitNewEntryClick
  }, _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseBulkImportFlyout.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))));
}