"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAppContext = void 0;
var _react = require("react");
var _app_context = require("../context/app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useAppContext = () => {
  const ctx = (0, _react.useContext)(_app_context.AppContext);
  if (!ctx) {
    throw new Error('"useAppContext" can only be called inside of AppContext.Provider!');
  }
  return ctx;
};
exports.useAppContext = useAppContext;