"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalExecutionLogRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../common");
var _verify_access_and_context = require("./verify_access_and_context");
var _rewrite_namespaces = require("./rewrite_namespaces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortOrderSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')]);
const sortFieldSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  timestamp: _configSchema.schema.object({
    order: sortOrderSchema
  })
}), _configSchema.schema.object({
  execution_duration: _configSchema.schema.object({
    order: sortOrderSchema
  })
}), _configSchema.schema.object({
  schedule_delay: _configSchema.schema.object({
    order: sortOrderSchema
  })
})]);
const sortFieldsSchema = _configSchema.schema.arrayOf(sortFieldSchema, {
  defaultValue: [{
    timestamp: {
      order: 'desc'
    }
  }]
});
const bodySchema = _configSchema.schema.object({
  date_start: _configSchema.schema.string(),
  date_end: _configSchema.schema.maybe(_configSchema.schema.string()),
  filter: _configSchema.schema.maybe(_configSchema.schema.string()),
  per_page: _configSchema.schema.number({
    defaultValue: 10,
    min: 1
  }),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  sort: sortFieldsSchema,
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
const rewriteBodyReq = ({
  date_start: dateStart,
  date_end: dateEnd,
  per_page: perPage,
  namespaces,
  ...rest
}) => ({
  ...rest,
  namespaces: (0, _rewrite_namespaces.rewriteNamespaces)(namespaces),
  dateStart,
  dateEnd,
  perPage
});
const getGlobalExecutionLogRoute = (router, licenseState) => {
  router.post({
    path: `${_common.INTERNAL_BASE_ACTION_API_PATH}/_global_connector_execution_logs`,
    validate: {
      body: bodySchema
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const actionsClient = (await context.actions).getActionsClient();
    return res.ok({
      body: await actionsClient.getGlobalExecutionLogWithAuth(rewriteBodyReq(req.body))
    });
  })));
};
exports.getGlobalExecutionLogRoute = getGlobalExecutionLogRoute;