"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorTypesResponseSchema = exports.connectorResponseSchema = exports.allConnectorsResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectorResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  config: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
  connector_type_id: _configSchema.schema.string(),
  is_missing_secrets: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  is_preconfigured: _configSchema.schema.boolean(),
  is_deprecated: _configSchema.schema.boolean(),
  is_system_action: _configSchema.schema.boolean()
});
exports.connectorResponseSchema = connectorResponseSchema;
const allConnectorsResponseSchema = connectorResponseSchema.extends({
  referenced_by_count: _configSchema.schema.number()
});
exports.allConnectorsResponseSchema = allConnectorsResponseSchema;
const connectorTypesResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  enabled_in_config: _configSchema.schema.boolean(),
  enabled_in_license: _configSchema.schema.boolean(),
  minimum_license_required: _configSchema.schema.oneOf([_configSchema.schema.literal('basic'), _configSchema.schema.literal('standard'), _configSchema.schema.literal('gold'), _configSchema.schema.literal('platinum'), _configSchema.schema.literal('enterprise'), _configSchema.schema.literal('trial')]),
  supported_feature_ids: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  is_system_action_type: _configSchema.schema.boolean()
});
exports.connectorTypesResponseSchema = connectorTypesResponseSchema;