"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTextStyles = exports.euiTextConstrainedMaxWidth = exports.euiText = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _link = require("../link/link.styles");
var _title = require("../title/title.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * TODO: Make this a global value so it can be set by theme?
 */
var euiTextConstrainedMaxWidth = 'max(64ch, 75%)';

/**
 * Mixins
 */
exports.euiTextConstrainedMaxWidth = euiTextConstrainedMaxWidth;
var euiText = function euiText(euiTheme) {
  var inheritColor = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return {
    color: inheritColor ? 'inherit' : euiTheme.colors.text,
    fontWeight: euiTheme.font.weight.regular
  };
};

// Internal utility for EuiText scales/sizes
exports.euiText = euiText;
var euiScaleText = function euiScaleText(euiThemeContext, options) {
  var _euiFontSize = (0, _global_styling.euiFontSize)(euiThemeContext, 'm', options),
    fontSize = _euiFontSize.fontSize,
    lineHeight = _euiFontSize.lineHeight;
  var euiTheme = euiThemeContext.euiTheme;
  var unit = options.unit,
    _customScale = options.customScale;
  var lineHeightSize = unit === 'em' ? "".concat(lineHeight, "em") : lineHeight;
  var headings = {
    h1: (0, _title.euiTitle)(euiThemeContext, 'l', options),
    h2: (0, _title.euiTitle)(euiThemeContext, 'm', options),
    h3: (0, _title.euiTitle)(euiThemeContext, 's', options),
    h4: (0, _title.euiTitle)(euiThemeContext, 'xs', options),
    h5: (0, _title.euiTitle)(euiThemeContext, 'xxs', options),
    h6: (0, _title.euiTitle)(euiThemeContext, 'xxxs', options)
  };
  // Generate margins for headings based on customScale (not on heading level)
  var customScale = _customScale === 'xxxs' ? 'xxs' : _customScale || 'm';
  var marginSize = euiTheme.size[customScale];
  var headingMarginTop = (0, _global_styling.mathWithUnits)(marginSize, function (x) {
    return x * 2;
  });
  var headingMarginBottom = marginSize;
  var blockQuoteBorderWidth = (0, _global_styling.mathWithUnits)(fontSize, function (x) {
    return x / 4;
  });
  return "\n    font-size: ".concat(fontSize, ";\n    line-height: ").concat(lineHeight, ";\n\n    h1 {\n      font-size: ").concat(headings.h1.fontSize, ";\n      line-height: ").concat(headings.h1.lineHeight, ";\n    }\n    h1:not(:last-child) {\n      ").concat((0, _global_styling.logicalCSS)('margin-bottom', headingMarginBottom), "\n    }\n\n    h2 {\n      font-size: ").concat(headings.h2.fontSize, ";\n      line-height: ").concat(headings.h2.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat((0, _global_styling.logicalCSS)('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat((0, _global_styling.logicalCSS)('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h3 {\n      font-size: ").concat(headings.h3.fontSize, ";\n      line-height: ").concat(headings.h3.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat((0, _global_styling.logicalCSS)('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat((0, _global_styling.logicalCSS)('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h4 {\n      font-size: ").concat(headings.h4.fontSize, ";\n      line-height: ").concat(headings.h4.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat((0, _global_styling.logicalCSS)('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat((0, _global_styling.logicalCSS)('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h5 {\n      font-size: ").concat(headings.h5.fontSize, ";\n      line-height: ").concat(headings.h5.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat((0, _global_styling.logicalCSS)('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat((0, _global_styling.logicalCSS)('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h6 {\n      font-size: ").concat(headings.h6.fontSize, ";\n      line-height: ").concat(headings.h6.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat((0, _global_styling.logicalCSS)('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat((0, _global_styling.logicalCSS)('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    p,\n    dl,\n    blockquote,\n    img,\n    pre,\n    > ul,\n    > ol {\n      ").concat((0, _global_styling.logicalCSS)('margin-bottom', lineHeightSize), "\n    }\n\n    ul,\n    ol {\n      ").concat((0, _global_styling.logicalCSS)('margin-left', lineHeightSize), "\n    }\n\n    /* The styles of the nested ordered lists follow the style of GitHub\n       which is commonly used in Markdown or MDX formatting. */\n    ol ol,\n    ul ol {\n      list-style-type: lower-roman;\n    }\n\n    ul ul ol,\n    ul ol ol,\n    ol ul ol,\n    ol ol ol {\n      list-style-type: lower-alpha;\n    }\n  \n    blockquote {\n      font-size: ").concat(fontSize, ";\n      ").concat((0, _global_styling.logicalShorthandCSS)('padding', "0 ".concat(fontSize)), "\n      ").concat((0, _global_styling.logicalCSS)('border-left-width', blockQuoteBorderWidth), "\n      ").concat((0, _global_styling.logicalCSS)('margin-bottom', fontSize), "\n    }\n\n    dd + dt {\n      ").concat((0, _global_styling.logicalCSS)('margin-top', fontSize), "\n    }\n\n    dt,\n    .eui-definitionListReverse dd {\n      font-size: ").concat(fontSize, ";\n      line-height: ").concat(lineHeight, ";\n    }\n\n    .eui-definitionListReverse dt {\n      font-size: ").concat((0, _global_styling.euiFontSize)(euiThemeContext, 'xs', options).fontSize, ";\n      color: ").concat(euiTheme.colors.text, ";\n    }\n\n    small {\n      font-size: ").concat((0, _global_styling.euiFontSize)(euiThemeContext, 's', options).fontSize, ";\n    }\n\n    pre:not(.euiCodeBlock__pre) {\n      padding: ").concat(lineHeightSize, ";\n    }\n\n    code:not(.euiCode):not(.euiCodeBlock__code)  {\n      font-size: .9em; /* 90% of parent font size */\n    }\n    ").concat(
  // when textSize is 'm', the 'kbd' element gets a line between the text and the border-bottom
  _customScale === 'm' ? "\n    kbd {\n      ".concat((0, _global_styling.logicalCSS)('padding-bottom', euiTheme.size.xs), "\n      /* Ensures the shape still looks like a square when only one character */\n      ").concat((0, _global_styling.logicalCSS)('min-width', euiTheme.size.l), "\n      ").concat((0, _global_styling.logicalTextAlignCSS)('center'), "\n    }\n    \n    kbd::after {\n      content: '';\n      ").concat((0, _global_styling.logicalCSS)('border-bottom', "".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.text)), "\n      position: absolute;\n      ").concat((0, _global_styling.logicalCSS)('bottom', euiTheme.size.xxs), "\n      ").concat((0, _global_styling.logicalCSS)('left', 0), "\n      ").concat((0, _global_styling.logicalCSS)('width', '100%'), "\n    }") : '', "\n  ");
};

/**
 * Styles
 */
var euiTextStyles = function euiTextStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiText: /*#__PURE__*/(0, _react.css)(euiText(euiTheme, true), "clear:both;a:not([class]){", (0, _link.euiLinkCSS)(euiThemeContext), ";}img{display:block;", (0, _global_styling.logicalCSS)('max-width', '100%'), ";}ul{list-style:disc;}ol{list-style:decimal;}blockquote{border-inline-start-color:", euiTheme.border.color, ";border-inline-start-style:solid;}blockquote:not(.euiMarkdownFormat__blockquote){color:", euiTheme.colors.subduedText, ";}h1{", (0, _title.euiTitle)(euiThemeContext, 'l'), ";}h2{", (0, _title.euiTitle)(euiThemeContext, 'm'), ";}h3{", (0, _title.euiTitle)(euiThemeContext, 's'), ";}h4,dt{", (0, _title.euiTitle)(euiThemeContext, 'xs'), ";}h5{", (0, _title.euiTitle)(euiThemeContext, 'xxs'), ";}h6{", (0, _title.euiTitle)(euiThemeContext, 'xxxs'), " text-transform:uppercase;}h1,h2,h3,h4,h5,h6,dt{color:inherit;}pre:not(.euiCodeBlock__pre){white-space:pre-wrap;background:", (0, _global_styling.euiBackgroundColor)(euiThemeContext, 'subdued'), ";color:", euiTheme.colors.text, ";}pre:not(.euiCodeBlock__pre),pre:not(.euiCodeBlock__pre) code{display:block;}>:last-child{", (0, _global_styling.logicalCSS)('margin-bottom', '0 !important'), ";}kbd{position:relative;display:inline-block;", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.xxs), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), " line-height:1;border:", euiTheme.border.width.thin, " solid ", euiTheme.colors.text, ";border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.small, function (x) {
      return x / 2;
    }), ";};label:euiText;"),
    constrainedWidth: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', euiTextConstrainedMaxWidth), ";;label:constrainedWidth;"),
    // Sizes
    m: /*#__PURE__*/(0, _react.css)(euiScaleText(euiThemeContext, {
      customScale: 'm'
    }), ";;label:m;"),
    s: /*#__PURE__*/(0, _react.css)(euiScaleText(euiThemeContext, {
      customScale: 's'
    }), ";;label:s;"),
    xs: /*#__PURE__*/(0, _react.css)(euiScaleText(euiThemeContext, {
      customScale: 'xs'
    }), ";;label:xs;"),
    relative: /*#__PURE__*/(0, _react.css)(euiScaleText(euiThemeContext, {
      unit: 'em'
    }), ";;label:relative;")
  };
};
exports.euiTextStyles = euiTextStyles;