"use strict";

var _react = _interopRequireDefault(require("react"));
var _ = require(".");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var users = [{
  id: '47936',
  firstName: 'Robert',
  lastName: 'Stein',
  github: 'steiner_rob',
  location: {
    city: 'Los Angeles',
    state: 'CA'
  }
}, {
  id: '54736',
  firstName: 'Martina',
  lastName: 'Conlon',
  github: 'martina_zen',
  location: {
    city: 'Boston',
    state: 'MA'
  }
}, {
  id: '40193',
  firstName: 'Alyce',
  lastName: 'Benning',
  github: 'alyce_benning',
  location: {
    city: 'Atlanta',
    state: 'GA'
  }
}];
var userRows = users.map(function (user) {
  var id = user.id,
    firstName = user.firstName,
    lastName = user.lastName,
    github = user.github,
    _user$location = user.location,
    city = _user$location.city,
    state = _user$location.state;
  return (0, _react2.jsx)(_.EuiTableRow, {
    key: id
  }, (0, _react2.jsx)(_.EuiTableRowCell, null, "".concat(firstName, " ").concat(lastName)), (0, _react2.jsx)(_.EuiTableRowCell, null, github), (0, _react2.jsx)(_.EuiTableRowCell, null, "".concat(city, ", ").concat(state)));
});
var customColumns = ['Name', 'Github', 'Location'];
var columnHeaders = customColumns.map(function (column, i) {
  return (0, _react2.jsx)(_.EuiTableHeaderCell, {
    key: i
  }, column);
});
var CustomTable = function CustomTable() {
  return (0, _react2.jsx)(_.EuiTable, null, (0, _react2.jsx)(_.EuiTableHeader, null, columnHeaders), (0, _react2.jsx)(_.EuiTableBody, null, userRows));
};
describe('EuiTable', function () {
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(CustomTable, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
  });
});