"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _side_nav = require("./side_nav");
var _icon = require("../icon");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
describe('EuiSideNav', function () {
  describe('Mobile EuiSideNav', function () {
    var MobileSideNav = function MobileSideNav() {
      var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        isSideNavOpenOnMobile = _useState2[0],
        setisSideNavOpenOnMobile = _useState2[1];
      var _toggleOpenOnMobile = function toggleOpenOnMobile() {
        setisSideNavOpenOnMobile(!isSideNavOpenOnMobile);
      };
      var basicSideNav = [{
        name: 'Root item',
        id: (0, _services.htmlIdGenerator)('basicExample')(),
        items: [{
          name: 'Item with onClick',
          id: (0, _services.htmlIdGenerator)('basicExample')()
        }, {
          name: 'Item with href',
          id: (0, _services.htmlIdGenerator)('basicExample')(),
          href: '/#/navigation/side-nav'
        }, {
          name: 'Selected item',
          id: (0, _services.htmlIdGenerator)('basicExample')(),
          isSelected: true
        }, {
          name: 'Disabled item',
          id: (0, _services.htmlIdGenerator)('basicExample')(),
          disabled: true
        }]
      }];
      return (0, _react2.jsx)(_side_nav.EuiSideNav, {
        "aria-label": "Basic example",
        mobileTitle: "Basic example",
        toggleOpenOnMobile: function toggleOpenOnMobile() {
          return _toggleOpenOnMobile();
        },
        isOpenOnMobile: isSideNavOpenOnMobile,
        style: {
          width: 192
        },
        items: basicSideNav
      });
    };
    beforeEach(function () {
      cy.viewport(375, 667); // small breakpoint
      cy.mount((0, _react2.jsx)(MobileSideNav, null));
    });
    describe('Automated accessibility check', function () {
      it('has zero violations when mobile side nav is rendered', function () {
        cy.checkAxe();
      });
      it('has zero violations when mobile side nav is expanded', function () {
        cy.get('button').contains('Basic example').realClick();
        cy.get('div.euiSideNav__content').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Simple EuiSideNav', function () {
    var SimpleSideNav = function SimpleSideNav() {
      var basicSideNav = [{
        name: 'Root item',
        id: (0, _services.htmlIdGenerator)('basicExample')(),
        items: [{
          name: 'Item with onClick',
          id: (0, _services.htmlIdGenerator)('basicExample')()
        }, {
          name: 'Item with href',
          id: (0, _services.htmlIdGenerator)('basicExample')(),
          href: '/#/navigation/side-nav'
        }, {
          name: 'Selected item',
          id: (0, _services.htmlIdGenerator)('basicExample')(),
          isSelected: true
        }, {
          name: 'Disabled item',
          id: (0, _services.htmlIdGenerator)('basicExample')(),
          disabled: true
        }]
      }];
      return (0, _react2.jsx)(_side_nav.EuiSideNav, {
        "aria-label": "Basic example",
        style: {
          width: 192
        },
        items: basicSideNav
      });
    };
    beforeEach(function () {
      cy.viewport(768, 1024); // medium breakpoint
      cy.mount((0, _react2.jsx)(SimpleSideNav, null));
      cy.get('nav.euiSideNav').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations when rendered using non-mobile breakpoint', function () {
        cy.get('nav.euiSideNav').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Nested EuiSideNav', function () {
    var NestedSideNav = function NestedSideNav() {
      var nestedSideNav = [{
        name: 'Kibana',
        id: 'kibana-1',
        icon: (0, _react2.jsx)(_icon.EuiIcon, {
          type: "logoKibana"
        }),
        isSelected: false,
        items: [{
          name: 'Has normal children',
          id: 'has-normal-children-1',
          isSelected: false
        }, {
          name: 'Normally not open',
          id: 'normally-not-open-1',
          isSelected: false,
          items: [{
            name: 'Open by override',
            id: 'open-by-override-1',
            isSelected: false,
            forceOpen: true,
            items: [{
              name: 'Child 3',
              id: 'child-3-1',
              isSelected: true
            }, {
              name: 'Child 4',
              id: 'child-4-1',
              isSelected: false
            }, {
              name: 'Child 5',
              id: 'child-5-1',
              isSelected: false
            }, {
              name: 'Child 6',
              id: 'child-6-1',
              isSelected: false,
              disabled: true
            }]
          }]
        }, {
          name: 'Has expanded children',
          id: 'has-expanded-children-1',
          isSelected: false,
          forceOpen: true,
          items: [{
            name: 'Child 7',
            id: 'child-7-1',
            isSelected: false
          }]
        }]
      }];
      return (0, _react2.jsx)(_side_nav.EuiSideNav, {
        "aria-label": "Force-open example",
        items: nestedSideNav,
        style: {
          width: 192
        }
      });
    };
    beforeEach(function () {
      cy.viewport(768, 1024); // medium breakpoint
      cy.mount((0, _react2.jsx)(NestedSideNav, null));
      cy.get('nav.euiSideNav').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations when complex side nav is rendered', function () {
        cy.checkAxe();
      });
    });
  });
  describe('Complex EuiSideNav', function () {
    var ComplexSideNav = function ComplexSideNav() {
      var complexSideNav = [{
        name: 'Elasticsearch',
        id: 'elasticsearch-1',
        icon: (0, _react2.jsx)(_icon.EuiIcon, {
          type: "logoElasticsearch"
        }),
        isSelected: false,
        items: [{
          name: 'Data sources',
          id: 'data-sources-1',
          isSelected: false
        }, {
          name: 'Users',
          id: 'users-1',
          isSelected: false
        }, {
          name: 'Roles',
          id: 'roles-1',
          isSelected: false
        }, {
          name: 'Watches',
          id: 'watches-1',
          isSelected: false
        }, {
          name: 'Extremely long title will become truncated when the browser is narrow enough',
          id: 'extremely-long-title-1',
          isSelected: false
        }]
      }, {
        name: 'Kibana',
        id: 'kibana-1',
        icon: (0, _react2.jsx)(_icon.EuiIcon, {
          type: "logoKibana"
        }),
        isSelected: false,
        items: [{
          name: 'Advanced settings',
          id: 'advanced-settings-1',
          isSelected: false,
          items: [{
            name: 'General',
            id: 'general-1',
            isSelected: false,
            disabled: true
          }, {
            name: 'Timelion',
            id: 'timelino-1',
            isSelected: false,
            items: [{
              name: 'Time stuff',
              id: 'time-stuff-1',
              icon: (0, _react2.jsx)(_icon.EuiIcon, {
                type: "clock"
              }),
              isSelected: true
            }, {
              name: 'Lion stuff',
              id: 'lion-stuff-1',
              icon: (0, _react2.jsx)(_icon.EuiIcon, {
                type: "stats"
              }),
              isSelected: false
            }]
          }, {
            name: 'Visualizations',
            id: 'visualizations-1',
            isSelected: false
          }]
        }, {
          name: 'Index patterns',
          id: 'index-patterns-1',
          isSelected: false
        }, {
          name: 'Saved objects',
          id: 'saved-objects-1',
          isSelected: false
        }, {
          name: 'Reporting',
          id: 'reporting-1',
          isSelected: false
        }]
      }, {
        name: 'Logstash',
        id: 'logstash-1',
        icon: (0, _react2.jsx)(_icon.EuiIcon, {
          type: "logoLogstash"
        }),
        isSelected: false,
        items: [{
          name: 'Pipeline viewer',
          id: 'data-sources-1',
          isSelected: false
        }]
      }];
      return (0, _react2.jsx)(_side_nav.EuiSideNav, {
        "aria-label": "Complex example",
        items: complexSideNav,
        style: {
          width: 192
        }
      });
    };
    beforeEach(function () {
      cy.viewport(768, 1024); // medium breakpoint
      cy.mount((0, _react2.jsx)(ComplexSideNav, null));
      cy.get('nav.euiSideNav').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations when complex side nav is rendered', function () {
        cy.checkAxe();
      });
    });
  });
});