"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiInputPopoverWidthContext = exports.EuiInputPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
var _classnames = _interopRequireDefault(require("classnames"));
var _tabbable = require("tabbable");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
var _resize_observer = require("../observer/resize_observer");
var _focus_trap = require("../focus_trap");
var _form = require("../form/form.styles");
var _popover = require("./popover");
var _excluded = ["children", "className", "closePopover", "anchorPosition", "attachToAnchor", "repositionToCrossAxis", "display", "panelPaddingSize", "closeOnScroll", "ownFocus", "disableFocusTrap", "focusTrapProps", "input", "fullWidth", "panelMinWidth", "onPanelResize", "inputRef", "panelRef"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
// Used by child components that want to know the parent popover width
var EuiInputPopoverWidthContext = /*#__PURE__*/(0, _react.createContext)(0);
exports.EuiInputPopoverWidthContext = EuiInputPopoverWidthContext;
var EuiInputPopover = function EuiInputPopover(_ref) {
  var _props$panelProps;
  var children = _ref.children,
    className = _ref.className,
    closePopover = _ref.closePopover,
    _ref$anchorPosition = _ref.anchorPosition,
    anchorPosition = _ref$anchorPosition === void 0 ? 'downLeft' : _ref$anchorPosition,
    _ref$attachToAnchor = _ref.attachToAnchor,
    attachToAnchor = _ref$attachToAnchor === void 0 ? true : _ref$attachToAnchor,
    _ref$repositionToCros = _ref.repositionToCrossAxis,
    repositionToCrossAxis = _ref$repositionToCros === void 0 ? false : _ref$repositionToCros,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'block' : _ref$display,
    _ref$panelPaddingSize = _ref.panelPaddingSize,
    panelPaddingSize = _ref$panelPaddingSize === void 0 ? 's' : _ref$panelPaddingSize,
    _ref$closeOnScroll = _ref.closeOnScroll,
    closeOnScroll = _ref$closeOnScroll === void 0 ? false : _ref$closeOnScroll,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? false : _ref$ownFocus,
    _ref$disableFocusTrap = _ref.disableFocusTrap,
    disableFocusTrap = _ref$disableFocusTrap === void 0 ? false : _ref$disableFocusTrap,
    focusTrapProps = _ref.focusTrapProps,
    input = _ref.input,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    _ref$panelMinWidth = _ref.panelMinWidth,
    panelMinWidth = _ref$panelMinWidth === void 0 ? 0 : _ref$panelMinWidth,
    onPanelResize = _ref.onPanelResize,
    _inputRef = _ref.inputRef,
    _panelRef = _ref.panelRef,
    props = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiInputPopover', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var form = (0, _form.euiFormVariables)(euiTheme);

  /**
   * Ref setup
   */

  var popoverClassRef = (0, _react.useRef)(null);
  // The inputEl state ensures that width is correctly tracked on initial load
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    inputEl = _useState2[0],
    setInputEl = _useState2[1];
  // The panelEl state ensures that width is correctly set every time the popover opens
  var _useState3 = (0, _react.useState)(null),
    _useState4 = _slicedToArray(_useState3, 2),
    panelEl = _useState4[0],
    setPanelEl = _useState4[1];
  var inputRef = (0, _services.useCombinedRefs)([setInputEl, _inputRef]);
  var panelRef = (0, _services.useCombinedRefs)([setPanelEl, _panelRef]);

  /**
   * Sizing/width logic
   */

  var inputWidth = (0, _resize_observer.useResizeObserver)(inputEl, 'width').width;
  var panelWidth = (0, _react.useMemo)(function () {
    return inputWidth < panelMinWidth ? panelMinWidth : inputWidth;
  }, [panelMinWidth, inputWidth]);

  // Resize callback
  (0, _react.useEffect)(function () {
    onPanelResize === null || onPanelResize === void 0 ? void 0 : onPanelResize(panelWidth);
  }, [panelWidth, onPanelResize]);
  (0, _react.useEffect)(function () {
    if (panelEl) {
      // We have to modify the popover panel DOM node directly instead of using
      // `panelStyle`, as there's some weird positioning bugs on resize otherwise
      panelEl.style.inlineSize = "".concat(panelWidth, "px");
    }
  }, [panelEl, panelWidth]);
  (0, _react.useEffect)(function () {
    // This fires on all input width changes regardless of minimum size, because on
    // right/center anchored popovers, the input width affects the position of the popover
    if (panelEl) {
      var _popoverClassRef$curr;
      (_popoverClassRef$curr = popoverClassRef.current) === null || _popoverClassRef$curr === void 0 ? void 0 : _popoverClassRef$curr.positionPopoverFluid();
    }
  }, [inputWidth, panelEl]);

  /**
   * Popover tab to close logic
   */

  var panelPropsOnKeyDown = (_props$panelProps = props.panelProps) === null || _props$panelProps === void 0 ? void 0 : _props$panelProps.onKeyDown;
  var onKeyDown = (0, _react.useCallback)(function (event) {
    panelPropsOnKeyDown === null || panelPropsOnKeyDown === void 0 ? void 0 : panelPropsOnKeyDown(event);
    if (event.key === _services.keys.TAB) {
      if (disableFocusTrap) {
        closePopover();
      } else {
        var tabbableItems = (0, _tabbable.tabbable)(event.currentTarget).filter(function (el) {
          return !el.hasAttribute('data-focus-guard');
        });
        if (!tabbableItems.length) return;
        var tabbingFromLastItemInPopover = document.activeElement === tabbableItems[tabbableItems.length - 1];
        if (tabbingFromLastItemInPopover) {
          closePopover();
        }
      }
    }
  }, [disableFocusTrap, closePopover, panelPropsOnKeyDown]);

  /**
   * Optional close on scroll behavior
   */

  (0, _react.useEffect)(function () {
    // When the popover opens, add a scroll listener to the page (& remove it after)
    if (closeOnScroll && panelEl) {
      // Close the popover, but only if the scroll event occurs outside the input or the popover itself
      var closePopoverOnScroll = function closePopoverOnScroll(event) {
        if (!panelEl || !inputEl || !event.target) return;
        var scrollTarget = event.target;
        if (panelEl.contains(scrollTarget) === false && inputEl.contains(scrollTarget) === false) {
          closePopover();
        }
      };

      // Firefox will trigger a scroll event in many common situations when the options list div is appended
      // to the DOM; in testing it was always within 100ms, but setting a timeout here for 500ms to be safe
      var timeoutId = setTimeout(function () {
        window.addEventListener('scroll', closePopoverOnScroll, {
          passive: true,
          // for better performance as we won't call preventDefault
          capture: true // scroll events don't bubble, they must be captured instead
        });
      }, 500);
      return function () {
        window.removeEventListener('scroll', closePopoverOnScroll, {
          capture: true
        });
        clearTimeout(timeoutId);
      };
    }
  }, [closeOnScroll, closePopover, panelEl, inputEl]);
  return (0, _react2.jsx)(_popover.EuiPopover, _extends({
    className: classes,
    css: /*#__PURE__*/(0, _react2.css)(fullWidth ? undefined : (0, _global_styling.logicalCSS)('max-width', form.maxWidth), ";label:EuiInputPopover;"),
    display: display,
    button: input,
    buttonRef: inputRef,
    panelRef: panelRef,
    ref: popoverClassRef,
    closePopover: closePopover,
    anchorPosition: anchorPosition,
    attachToAnchor: attachToAnchor,
    repositionToCrossAxis: repositionToCrossAxis,
    panelPaddingSize: panelPaddingSize,
    ownFocus: ownFocus
  }, props, {
    panelProps: _objectSpread(_objectSpread({}, props.panelProps), {}, {
      onKeyDown: onKeyDown
    })
  }), (0, _react2.jsx)(_focus_trap.EuiFocusTrap, _extends({
    clickOutsideDisables: true,
    disabled: disableFocusTrap
  }, focusTrapProps), (0, _react2.jsx)(EuiInputPopoverWidthContext.Provider, {
    value: panelWidth
  }, children)));
};
exports.EuiInputPopover = EuiInputPopover;
EuiInputPopover.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Alignment of the popover relative to the input
     */
  anchorPosition: _propTypes.default.oneOf(["downLeft", "downRight", "downCenter"]),
  disableFocusTrap: _propTypes.default.bool,
  /**
     * Allows automatically closing the input popover on page scroll
     */
  closeOnScroll: _propTypes.default.bool,
  fullWidth: _propTypes.default.bool,
  input: _propTypes.default.any.isRequired,
  inputRef: _propTypes.default.any,
  onPanelResize: _propTypes.default.func,
  /**
     * By default, **EuiInputPopovers** inherit the same width as the passed input element.
     * However, if the input width is too small, you can pass a minimum panel width
     * (that should be based on the popover content).
     */
  panelMinWidth: _propTypes.default.number
};