"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiInlineEditText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _text = require("../text");
var _inline_edit_form = require("./inline_edit_form");
var _services = require("../../services");
var _inline_edit_text = require("./inline_edit_text.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "size", "readModeProps", "isReadOnly"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiInlineEditText = function EuiInlineEditText(_ref) {
  var className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _readModeProps = _ref.readModeProps,
    isReadOnly = _ref.isReadOnly,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiInlineEditText', className);
  var theme = (0, _services.useEuiTheme)();
  var styles = (0, _inline_edit_text.euiInlineEditTextStyles)(theme);
  var cssStyles = [styles.euiInlineEditText, styles.fontSize[size]];
  var isSmallSize = ['xs', 's'].includes(size);
  var sizes = isSmallSize ? _inline_edit_form.SMALL_SIZE_FORM : _inline_edit_form.MEDIUM_SIZE_FORM;
  var readModeProps = (0, _react.useMemo)(function () {
    if (!isReadOnly) return _readModeProps;
    return _objectSpread(_objectSpread({}, _readModeProps), {}, {
      role: 'paragraph'
    });
  }, [_readModeProps, isReadOnly]);
  return (0, _react2.jsx)(_inline_edit_form.EuiInlineEditForm, _extends({
    className: classes,
    css: cssStyles,
    readModeProps: readModeProps,
    isReadOnly: isReadOnly,
    sizes: sizes
  }, rest), function (textReadModeValue) {
    return (0, _react2.jsx)(_text.EuiText, {
      size: size,
      className: "eui-textTruncate"
    }, textReadModeValue);
  });
};
exports.EuiInlineEditText = EuiInlineEditText;
EuiInlineEditText.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  placeholder: _propTypes.default.string,
  /**
       * Callback that fires when a user clicks the save button.
       * Passes the current edited text value as an argument.
       *
       * To validate the value of the edited text, pass back a boolean flag.
       * If `false`, EuiInlineEdit will remain in edit mode, where loading or invalid states can be set.
       * If `true`, EuiInlineEdit will return to read mode.
       */
  onSave: _propTypes.default.func,
  /**
       * Form label that appears above the form control.
       * This is required for accessibility because there is no visual label on the input.
       */
  inputAriaLabel: _propTypes.default.string.isRequired,
  /**
       * Starts the component in edit mode
       */
  startWithEditOpen: _propTypes.default.bool,
  /**
       * Props that will be applied directly to the `EuiEmptyButton` displayed in read mode
       */
  readModeProps: _propTypes.default.any,
  /**
       * Multiple props objects that can be applied directly to various child components displayed in edit mode.
       * - `formRowProps` will be passed to `EuiFormRow`
       * - `inputProps` will be passed to `EuiFieldText`
       * - `saveButtonProps` & `cancelButtonProps` will be passed to their respective `EuiIconButton`s
       */
  editModeProps: _propTypes.default.shape({
    formRowProps: _propTypes.default.any,
    inputProps: _propTypes.default.any,
    saveButtonProps: _propTypes.default.any,
    cancelButtonProps: _propTypes.default.any
  }),
  /**
       * Loading state - only displayed in edit mode
       */
  isLoading: _propTypes.default.bool,
  /**
       * Invalid state - only displayed edit mode
       */
  isInvalid: _propTypes.default.bool,
  /**
       * Locks inline edit in read mode and displays the text value
       */
  isReadOnly: _propTypes.default.bool,
  /**
         * Initial inline edit text value
         */
  defaultValue: _propTypes.default.string,
  /**
         * To use inline edit as a controlled component, continuously pass the value via this prop
         */
  value: _propTypes.default.string,
  /**
         * Callback required to receive and update `value` based on user input
         */
  onChange: _propTypes.default.func,
  /**
         * Callback required to reset `value` to the previous read mode text value.
         */
  onCancel: _propTypes.default.func,
  /**
     * Text size level
     */
  size: _propTypes.default.any
};