"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiHeaderAlertStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _title = require("../../title/title.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiHeaderAlertStyles = function euiHeaderAlertStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiHeaderAlert: /*#__PURE__*/(0, _react.css)("position:relative;", (0, _global_styling.logicalCSS)('min-width', '300px'), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.s), " &:not(:last-child){", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.l), " ", (0, _global_styling.logicalCSS)('padding-bottom', euiTheme.size.l), " ", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), ";};label:euiHeaderAlert;"),
    euiHeaderAlert__title: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xs'), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.s), ";;label:euiHeaderAlert__title;"),
    euiHeaderAlert__text: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.base), ";;label:euiHeaderAlert__text;"),
    euiHeaderAlert__action: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:euiHeaderAlert__action;"),
    euiHeaderAlert__date: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), " color:", euiTheme.colors.darkShade, ";;label:euiHeaderAlert__date;")
  };
};
exports.euiHeaderAlertStyles = euiHeaderAlertStyles;