"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiValidatableControl = exports.EuiValidatableControl = void 0;
var _react = require("react");
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */
function isMutableRef(ref) {
  return ref != null && ref.hasOwnProperty('current');
}

/**
 * The `EuiValidatableControl` component should be used in scenarios where
 * we can render the validated `<input>` as its direct child.
 */

var EuiValidatableControl = function EuiValidatableControl(_ref) {
  var isInvalid = _ref.isInvalid,
    children = _ref.children;
  // Note that this must be state and not a ref to cause a rerender/set invalid state on initial mount
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    control = _useState2[0],
    setControl = _useState2[1];
  var child = _react.Children.only(children);
  var childRef = child.ref;
  var replacedRef = (0, _react.useCallback)(function (element) {
    setControl(element);

    // Call the original ref, if any
    if (typeof childRef === 'function') {
      childRef(element);
    } else if (isMutableRef(childRef)) {
      childRef.current = element;
    }
  }, [childRef]);
  useSetControlValidity({
    controlEl: control,
    isInvalid: isInvalid
  });
  return /*#__PURE__*/(0, _react.cloneElement)(child, {
    ref: replacedRef,
    'aria-invalid': isInvalid || child.props['aria-invalid']
  });
};

/**
 * The `UseEuiValidatableControl` hook should be used in scenarios where
 * we *cannot* control where the validated `<input>` is rendered (e.g., ReactDatePicker)
 * and instead need to access the input via a ref and pass the element in directly
 */
exports.EuiValidatableControl = EuiValidatableControl;
EuiValidatableControl.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  isInvalid: _propTypes.default.bool,
  children: _propTypes.default.shape({
    ref: _propTypes.default.any
  }).isRequired
};
var useEuiValidatableControl = function useEuiValidatableControl(_ref2) {
  var isInvalid = _ref2.isInvalid,
    controlEl = _ref2.controlEl;
  useSetControlValidity({
    controlEl: controlEl,
    isInvalid: isInvalid
  });
  (0, _react.useEffect)(function () {
    if (!controlEl) return;
    if (typeof isInvalid === 'boolean') {
      controlEl.setAttribute('aria-invalid', String(isInvalid));
    } else {
      controlEl.removeAttribute('aria-invalid');
    }
  }, [isInvalid, controlEl]);
};

/**
 * Internal `setCustomValidity` helper
 */
exports.useEuiValidatableControl = useEuiValidatableControl;
var useSetControlValidity = function useSetControlValidity(_ref3) {
  var controlEl = _ref3.controlEl,
    isInvalid = _ref3.isInvalid;
  (0, _react.useEffect)(function () {
    if (controlEl == null || typeof controlEl.setCustomValidity !== 'function') {
      return;
    }
    if (isInvalid) {
      controlEl.setCustomValidity('Invalid');
    } else {
      controlEl.setCustomValidity('');
    }
  }, [isInvalid, controlEl]);
};