"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeLevels = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _range_levels_colors = require("./range_levels_colors");
var _range_levels = require("./range_levels.styles");
var _utils = require("./utils");
var _react2 = require("@emotion/react");
var _excluded = ["levels", "max", "min", "showTicks", "showRange", "trackWidth"],
  _excluded2 = ["color", "className", "min", "max"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiRangeLevels = function EuiRangeLevels(_ref) {
  var _ref$levels = _ref.levels,
    levels = _ref$levels === void 0 ? [] : _ref$levels,
    max = _ref.max,
    min = _ref.min,
    showTicks = _ref.showTicks,
    showRange = _ref.showRange,
    trackWidth = _ref.trackWidth,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_levels.euiRangeLevelsStyles)(euiTheme);
  var cssStyles = [styles.euiRangeLevels, showTicks && styles.hasTicks, showRange && styles.hasRange];
  return (0, _react2.jsx)("div", _extends({
    className: "euiRangeLevels",
    css: cssStyles
  }, rest), levels.map(function (level, index) {
    return (0, _react2.jsx)(EuiRangeLevelElement, {
      key: index,
      level: level,
      min: min,
      max: max,
      trackWidth: trackWidth
    });
  }));
};

// Internal subcomponent
exports.EuiRangeLevels = EuiRangeLevels;
EuiRangeLevels.propTypes = {
  trackWidth: _propTypes.default.number.isRequired,
  style: _propTypes.default.any
};
var EuiRangeLevelElement = function EuiRangeLevelElement(_ref2) {
  var level = _ref2.level,
    min = _ref2.min,
    max = _ref2.max,
    trackWidth = _ref2.trackWidth;
  var color = level.color,
    className = level.className,
    levelMin = level.min,
    levelMax = level.max,
    levelRest = _objectWithoutProperties(level, _excluded2);
  var isNamedColor = (0, _react.useMemo)(function () {
    return (0, _range_levels_colors.isNamedLevelColor)(color);
  }, [color]);
  (0, _react.useEffect)(function () {
    validateLevelIsInRange({
      min: levelMin,
      max: levelMax
    }, {
      min: min,
      max: max
    });
  }, [levelMin, levelMax, min, max]);
  var styles = (0, _react.useMemo)(function () {
    var left = 0;
    var right = 0;
    var leftOffset = 0;
    var rightOffset = 0;
    if (trackWidth > 0) {
      left = levelMin === min ? 0 : (0, _utils.calculateThumbPosition)(levelMin, min, max, trackWidth);
      leftOffset = calculateOffset(left, levelMin, min);
      right = levelMax === max ? 100 : (0, _utils.calculateThumbPosition)(levelMax, min, max, trackWidth);
      rightOffset = calculateOffset(right, levelMax, max);
    }
    return (0, _global_styling.logicalStyles)({
      left: "calc(".concat(left, "% + ").concat(leftOffset, "px)"),
      right: "calc(".concat(100 - right, "% - ").concat(rightOffset, "px)"),
      backgroundColor: !isNamedColor ? color : undefined
    });
  }, [levelMin, levelMax, min, max, trackWidth, isNamedColor, color]);
  var levelClasses = (0, _classnames.default)('euiRangeLevel', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var levelStyles = (0, _range_levels.euiRangeLevelStyles)(euiTheme);
  var cssLevelStyles = [levelStyles.euiRangeLevel, isNamedColor ? levelStyles[color] : levelStyles.customColor];
  return (0, _react2.jsx)("span", _extends({
    style: styles,
    className: levelClasses,
    css: cssLevelStyles
  }, levelRest));
};
EuiRangeLevelElement.propTypes = {
  level: _propTypes.default.shape({
    /**
       * Accepts one of `["primary", "success", "warning", "danger"]` or a valid CSS color value.
       */
    color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired,
  min: _propTypes.default.any.isRequired,
  max: _propTypes.default.any.isRequired,
  trackWidth: _propTypes.default.number.isRequired
};
var validateLevelIsInRange = function validateLevelIsInRange(level, _ref3) {
  var min = _ref3.min,
    max = _ref3.max;
  if (level.min < min) {
    throw new Error("The level min of ".concat(level.min, " is lower than the min value of ").concat(min, "."));
  }
  if (level.max > max) {
    throw new Error("The level max of ".concat(level.max, " is higher than the max value of ").concat(max, "."));
  }
};
var calculateOffset = function calculateOffset(position, value, bound) {
  var threshold = 30;
  var offset = value === bound ? 0 : _utils.EUI_THUMB_SIZE / 2;
  if (offset !== 0) {
    // Estimating offset by eye. Trying to account for range scaling at both ends.
    offset = position <= threshold ? offset + 1 / position * threshold : offset;
    offset = position >= 100 - threshold ? offset - 1 / (100 - position) * threshold : offset;
  }
  return offset;
};