"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _radio_group = require("./radio_group");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />
var RadioGroup = function RadioGroup() {
  var radioGroupItemId__1 = 'cy-radio-id-1';
  var radioGroupItemId__2 = 'cy-radio-id-2';
  var radioGroupItemId__3 = 'cy-radio-id-3';
  var radioGroupItemId__4 = 'cy-radio-id-4';
  var radios = [{
    id: radioGroupItemId__1,
    label: 'Option one'
  }, {
    id: radioGroupItemId__2,
    label: 'Option two'
  }, {
    id: radioGroupItemId__3,
    label: 'Option three is disabled',
    disabled: true
  }, {
    id: radioGroupItemId__4,
    label: 'Option four'
  }];
  var _useState = (0, _react.useState)(radioGroupItemId__1),
    _useState2 = _slicedToArray(_useState, 2),
    radioIdSelected = _useState2[0],
    setRadioIdSelected = _useState2[1];
  return (0, _react2.jsx)(_radio_group.EuiRadioGroup, {
    options: radios,
    idSelected: radioIdSelected,
    onChange: function onChange(id) {
      return setRadioIdSelected(id);
    },
    name: "radio group",
    legend: {
      children: (0, _react2.jsx)("span", null, "This is a legend for a radio group")
    }
  });
};
describe('EuiRadioGroup', function () {
  beforeEach(function () {
    cy.realMount((0, _react2.jsx)(RadioGroup, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations after traversing radio group', function () {
      cy.realPress('Tab');
      cy.get('#cy-radio-id-1').should('have.focus');
      cy.realPress('Space');
      cy.get('#cy-radio-id-1').should('be.checked');
      cy.realPress('ArrowDown');
      cy.get('#cy-radio-id-2').should('be.checked');
      cy.realPress('ArrowRight');
      cy.get('#cy-radio-id-3').should('not.be.checked');
      cy.get('#cy-radio-id-4').should('be.checked');
      cy.checkAxe();
    });
  });
  describe('Disabled radio button accessibility', function () {
    it('affects no change after clicking the disabled radio button', function () {
      cy.get('#cy-radio-id-3').realClick();
      cy.get('#cy-radio-id-3').should('not.be.checked');
      cy.checkAxe();
    });
  });
});