"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _link = require("../../link");
var _collapsible_nav_link = require("./collapsible_nav_link.styles");
var _react2 = require("@emotion/react");
var _excluded = ["href", "rel", "children", "className", "isSelected", "isInteractive", "isNotAccordion", "isSubItem", "linkProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
/**
 * Internal nav link component.
 *
 * Can be rendered as a standalone nav item, or as part of an accordion header.
 * Can also be rendered as top-level item (has a background hover) or as a
 * sub-item (renders closer to plain text).
 *
 * In terms of DOM output, follows the same logic as EuiLink (renders either
 * an `a` tag or a `button` if no valid link exists), and can also additionally
 * rendered a plain `span` if the item is not interactive.
 */
var EuiCollapsibleNavLink = function EuiCollapsibleNavLink(_ref) {
  var href = _ref.href,
    rel = _ref.rel,
    children = _ref.children,
    className = _ref.className,
    isSelected = _ref.isSelected,
    _ref$isInteractive = _ref.isInteractive,
    isInteractive = _ref$isInteractive === void 0 ? true : _ref$isInteractive,
    isNotAccordion = _ref.isNotAccordion,
    isSubItem = _ref.isSubItem,
    linkProps = _ref.linkProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCollapsibleNavLink', className, isInteractive && (linkProps === null || linkProps === void 0 ? void 0 : linkProps.className));
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _collapsible_nav_link.euiCollapsibleNavLinkStyles)(euiTheme);
  var cssStyles = [styles.euiCollapsibleNavLink, isSelected && styles.isSelected, isSubItem ? styles.isSubItem : styles.isTopItem.isTopItem, isNotAccordion && !isSubItem && styles.isTopItem.isNotAccordion, isInteractive && !isSelected && !isSubItem && styles.isTopItem.isInteractive, isInteractive && (linkProps === null || linkProps === void 0 ? void 0 : linkProps.css)];
  return isInteractive ? (0, _react2.jsx)(_link.EuiLink, _extends({
    href: href,
    rel: rel
  }, _objectSpread(_objectSpread({}, rest), linkProps), {
    // EuiLink ExclusiveUnion shenanigans
    className: classes,
    css: cssStyles
  }), children) : (0, _react2.jsx)("span", _extends({
    className: classes,
    css: cssStyles
  }, rest), children);
};
exports.EuiCollapsibleNavLink = EuiCollapsibleNavLink;
EuiCollapsibleNavLink.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Highlights whether an item is currently selected, e.g.
       * if the user is on the same page as the nav link
       */
  isSelected: _propTypes.default.bool,
  /**
     * Determines whether the item should render as a top-level nav item
     * or a nested nav subitem. Set internally by EUI
     */
  isSubItem: _propTypes.default.bool,
  children: _propTypes.default.node.isRequired,
  isInteractive: _propTypes.default.bool,
  isNotAccordion: _propTypes.default.bool
};