"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _button = require("../../button");
var _i18n = require("../../i18n");
var _context = require("../context");
var _collapsible_nav_button = require("./collapsible_nav_button.styles");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = require("@emotion/react");
var _excluded = ["className", "css"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiCollapsibleNavButton = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var className = _ref.className,
    css = _ref.css,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    side = _useContext.side,
    isPush = _useContext.isPush,
    isCollapsed = _useContext.isCollapsed,
    isOverlayOpen = _useContext.isOverlayOpen;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _collapsible_nav_button.euiCollapsibleNavButtonWrapperStyles)(euiTheme);
  var cssStyles = [styles.euiCollapsibleNavButtonWrapper, styles[side]];
  var buttonStyles = [styles.euiCollapsibleNavButton, css];
  var classes = (0, _classnames.default)('euiCollapsibleNavButton', className);
  var toggleExpandLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavButton.ariaLabelExpand', 'Expand navigation');
  var toggleCollapseLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavButton.ariaLabelCollapse', 'Collapse navigation');
  var toggleOpenLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavButton.ariaLabelOpen', 'Open navigation');
  var toggleCloseLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavButton.ariaLabelClose', 'Close navigation');
  var ariaLabel;
  var iconType;
  if (isPush) {
    ariaLabel = isCollapsed ? toggleExpandLabel : toggleCollapseLabel;
    if (side === 'left') {
      iconType = isCollapsed ? 'menuRight' : 'menuLeft';
    } else {
      iconType = isCollapsed ? 'menuLeft' : 'menuRight';
    }
  } else {
    ariaLabel = isOverlayOpen ? toggleCloseLabel : toggleOpenLabel;
    iconType = isOverlayOpen ? 'cross' : 'menu';
  }
  return (0, _react2.jsx)("div", {
    className: "euiCollapsibleNavButtonWrapper",
    css: cssStyles,
    ref: ref
  }, (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
    "data-test-subj": "euiCollapsibleNavButton",
    className: classes,
    css: buttonStyles,
    size: "s",
    color: "text",
    iconType: iconType,
    "aria-label": ariaLabel,
    "aria-pressed": isPush ? !isCollapsed : isOverlayOpen,
    "aria-expanded": isPush ? !isCollapsed : isOverlayOpen
  }, rest)));
});
exports.EuiCollapsibleNavButton = EuiCollapsibleNavButton;
EuiCollapsibleNavButton.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};
EuiCollapsibleNavButton.displayName = 'EuiCollapsibleNavButton';