"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCollapsibleNavBetaStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _themes = require("../../themes");
var _header = require("../header/header.styles");
var _collapsible_nav_body_footer = require("./collapsible_nav_body_footer.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiCollapsibleNavBetaStyles = function euiCollapsibleNavBetaStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // At least for serverless, EuiCollapsibleNav is only going to be used with 1
  // fixed header. For those scenarios, we can prevent a minor layout jump on
  // page load by setting the CSS var fallback to the height of a single header
  var defaultHeaderHeight = (0, _header.euiHeaderVariables)(euiThemeContext).height;
  var fixedHeaderOffset = "var(--euiFixedHeadersOffset, ".concat(defaultHeaderHeight, ")");
  return {
    euiCollapsibleNavBeta: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', fixedHeaderOffset), (0, _global_styling.logicalCSS)('padding-bottom', euiTheme.size.xs), ";;label:euiCollapsibleNavBeta;"),
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-right', euiTheme.border.thin), ";;label:left;"),
    right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-left', euiTheme.border.thin), ";;label:right;"),
    isPush: /*#__PURE__*/(0, _react.css)((0, _themes.euiShadowFlat)(euiThemeContext), ";;label:isPush;"),
    isPushCollapsed: /*#__PURE__*/(0, _react.css)(_collapsible_nav_body_footer.hideScrollbars, ";;label:isPushCollapsed;"),
    isOverlayFullWidth: /*#__PURE__*/(0, _react.css)("&.euiFlyout{", (0, _global_styling.logicalCSS)('max-width', '100% !important'), ";};label:isOverlayFullWidth;")
  };
};
exports.euiCollapsibleNavBetaStyles = euiCollapsibleNavBetaStyles;