"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAccordionChildren = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _resize_observer = require("../../observer/resize_observer");
var _accordion_children_loading = require("./accordion_children_loading");
var _accordion_children = require("./accordion_children.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "accordionChildrenRef", "paddingSize", "isLoading", "isLoadingMessage", "isOpen"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiAccordionChildren = function EuiAccordionChildren(_ref) {
  var children = _ref.children,
    accordionChildrenRef = _ref.accordionChildrenRef,
    paddingSize = _ref.paddingSize,
    isLoading = _ref.isLoading,
    isLoadingMessage = _ref.isLoadingMessage,
    isOpen = _ref.isOpen,
    rest = _objectWithoutProperties(_ref, _excluded);
  /**
   * Children
   */
  var classes = (0, _classnames.default)('euiAccordion__children', {
    'euiAccordion__children-isLoading': isLoading
  });
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _accordion_children.euiAccordionChildrenStyles)(euiTheme);
  var cssStyles = [styles.euiAccordion__children, isLoading && styles.isLoading, paddingSize && paddingSize !== 'none' && styles[paddingSize]];

  /**
   * Wrapper
   */
  var wrapperStyles = (0, _accordion_children.euiAccordionChildWrapperStyles)(euiTheme);
  var wrapperCssStyles = [wrapperStyles.euiAccordion__childWrapper, isOpen ? wrapperStyles.isOpen : wrapperStyles.isClosed];

  /**
   * Update the accordion wrapper height whenever the accordion opens, and also
   * whenever the child content updates (which will change the height)
   */
  var _useState = (0, _react.useState)(0),
    _useState2 = _slicedToArray(_useState, 2),
    contentHeight = _useState2[0],
    setContentHeight = _useState2[1];
  var onResize = (0, _react.useCallback)(function (_ref2) {
    var height = _ref2.height;
    return setContentHeight(Math.round(height));
  }, []);
  var heightInlineStyle = (0, _react.useMemo)(function () {
    return {
      blockSize: isOpen ? contentHeight : 0
    };
  }, [isOpen, contentHeight]);
  return (0, _react2.jsx)("div", _extends({}, rest, {
    className: "euiAccordion__childWrapper",
    css: wrapperCssStyles,
    style: heightInlineStyle,
    ref: accordionChildrenRef,
    role: "region",
    tabIndex: -1
    // @ts-expect-error - inert property not yet available in React TS defs. TODO: Remove this once https://github.com/DefinitelyTyped/DefinitelyTyped/pull/60822 is merged
    ,
    inert: !isOpen ? '' : undefined // Can't pass a boolean currently, Jest throws errors
  }), (0, _react2.jsx)(_resize_observer.EuiResizeObserver, {
    onResize: onResize
  }, function (resizeRef) {
    return (0, _react2.jsx)("div", {
      ref: resizeRef,
      className: classes,
      css: cssStyles
    }, isLoading && isLoadingMessage ? (0, _react2.jsx)(_accordion_children_loading.EuiAccordionChildrenLoading, {
      isLoadingMessage: isLoadingMessage
    }) : children);
  }));
};
exports.EuiAccordionChildren = EuiAccordionChildren;
EuiAccordionChildren.propTypes = {
  isOpen: _propTypes.default.bool.isRequired,
  accordionChildrenRef: _propTypes.default.any.isRequired
};