/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { __extends, __generator } from "tslib";
import { hashAttributes } from '../utils';
var HashMap = /** @class */ (function () {
    function HashMap(_hash) {
        this._hash = _hash;
        this._valueMap = new Map();
        this._keyMap = new Map();
    }
    HashMap.prototype.get = function (key, hashCode) {
        hashCode !== null && hashCode !== void 0 ? hashCode : (hashCode = this._hash(key));
        return this._valueMap.get(hashCode);
    };
    HashMap.prototype.getOrDefault = function (key, defaultFactory) {
        var hash = this._hash(key);
        if (this._valueMap.has(hash)) {
            return this._valueMap.get(hash);
        }
        var val = defaultFactory();
        if (!this._keyMap.has(hash)) {
            this._keyMap.set(hash, key);
        }
        this._valueMap.set(hash, val);
        return val;
    };
    HashMap.prototype.set = function (key, value, hashCode) {
        hashCode !== null && hashCode !== void 0 ? hashCode : (hashCode = this._hash(key));
        if (!this._keyMap.has(hashCode)) {
            this._keyMap.set(hashCode, key);
        }
        this._valueMap.set(hashCode, value);
    };
    HashMap.prototype.has = function (key, hashCode) {
        hashCode !== null && hashCode !== void 0 ? hashCode : (hashCode = this._hash(key));
        return this._valueMap.has(hashCode);
    };
    HashMap.prototype.keys = function () {
        var keyIterator, next;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    keyIterator = this._keyMap.entries();
                    next = keyIterator.next();
                    _a.label = 1;
                case 1:
                    if (!(next.done !== true)) return [3 /*break*/, 3];
                    return [4 /*yield*/, [next.value[1], next.value[0]]];
                case 2:
                    _a.sent();
                    next = keyIterator.next();
                    return [3 /*break*/, 1];
                case 3: return [2 /*return*/];
            }
        });
    };
    HashMap.prototype.entries = function () {
        var valueIterator, next;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    valueIterator = this._valueMap.entries();
                    next = valueIterator.next();
                    _a.label = 1;
                case 1:
                    if (!(next.done !== true)) return [3 /*break*/, 3];
                    // next.value[0] here can not be undefined
                    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                    return [4 /*yield*/, [this._keyMap.get(next.value[0]), next.value[1], next.value[0]]];
                case 2:
                    // next.value[0] here can not be undefined
                    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                    _a.sent();
                    next = valueIterator.next();
                    return [3 /*break*/, 1];
                case 3: return [2 /*return*/];
            }
        });
    };
    Object.defineProperty(HashMap.prototype, "size", {
        get: function () {
            return this._valueMap.size;
        },
        enumerable: false,
        configurable: true
    });
    return HashMap;
}());
export { HashMap };
var AttributeHashMap = /** @class */ (function (_super) {
    __extends(AttributeHashMap, _super);
    function AttributeHashMap() {
        return _super.call(this, hashAttributes) || this;
    }
    return AttributeHashMap;
}(HashMap));
export { AttributeHashMap };
//# sourceMappingURL=HashMap.js.map