"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WatchStatusPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _breadcrumbs = require("../../lib/breadcrumbs");
var _api = require("../../lib/api");
var _navigation = require("../../lib/navigation");
var _app_context = require("../../app_context");
var _components = require("../../components");
var _components2 = require("./components");
var _watch_details_context = require("./watch_details_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TABS = [{
  id: 'executionHistoryTab',
  name: _i18n.i18n.translate('xpack.watcher.sections.watchStatus.executionHistoryTabLabel', {
    defaultMessage: 'Execution history'
  })
}, {
  id: 'actionStatusesTab',
  name: _i18n.i18n.translate('xpack.watcher.sections.watchStatus.actionsTabLabel', {
    defaultMessage: 'Action statuses'
  })
}];
const WatchStatusPage = ({
  match: {
    params: {
      id
    }
  }
}) => {
  const {
    setBreadcrumbs,
    toasts
  } = (0, _app_context.useAppContext)();
  const {
    error: watchDetailError,
    data: watchDetail,
    isLoading: isWatchDetailLoading
  } = (0, _api.useLoadWatchDetail)(id);
  const [selectedTab, setSelectedTab] = (0, _react.useState)('executionHistoryTab');
  const [isActivated, setIsActivated] = (0, _react.useState)(undefined);
  const [watchesToDelete, setWatchesToDelete] = (0, _react.useState)([]);
  const [isTogglingActivation, setIsTogglingActivation] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setBreadcrumbs([_breadcrumbs.listBreadcrumb, _breadcrumbs.statusBreadcrumb]);
  }, [id, setBreadcrumbs]);
  const errorCode = (0, _components.getPageErrorCode)(watchDetailError);
  if (isWatchDetailLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, null, /*#__PURE__*/_react.default.createElement(_components.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchStatus.loadingWatchDetailsDescription",
      defaultMessage: "Loading watch details\u2026"
    })));
  }
  if (errorCode) {
    return /*#__PURE__*/_react.default.createElement(_components.PageError, {
      errorCode: errorCode,
      id: id
    });
  }
  if (watchDetail) {
    const {
      isSystemWatch,
      id: watchId,
      watchStatus,
      name: watchName
    } = watchDetail;
    if (isActivated === undefined) {
      // Set initial value for isActivated based on the watch we just loaded.
      setIsActivated(typeof watchStatus.isActive !== 'undefined' ? watchStatus.isActive : false);
    }
    const activationButtonText = isActivated ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchHistory.watchTable.deactivateWatchLabel",
      defaultMessage: "Deactivate"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchHistory.watchTable.activateWatchLabel",
      defaultMessage: "Activate"
    });
    const toggleWatchActivation = async () => {
      const toggleActivation = isActivated ? _api.deactivateWatch : _api.activateWatch;
      setIsTogglingActivation(true);
      const {
        error
      } = await toggleActivation(watchId);
      setIsTogglingActivation(false);
      if (error) {
        const message = isActivated ? _i18n.i18n.translate('xpack.watcher.sections.watchList.toggleActivatationErrorNotification.deactivateDescriptionText', {
          defaultMessage: "Couldn't deactivate watch"
        }) : _i18n.i18n.translate('xpack.watcher.sections.watchList.toggleActivatationErrorNotification.activateDescriptionText', {
          defaultMessage: "Couldn't activate watch"
        });
        return toasts.addDanger(message);
      }
      setIsActivated(!isActivated);
    };
    const selectedPanel = selectedTab === 'executionHistoryTab' ? /*#__PURE__*/_react.default.createElement(_components2.ExecutionHistoryPanel, null) : selectedTab === 'actionStatusesTab' ? /*#__PURE__*/_react.default.createElement(_components2.ActionStatusesPanel, null) : undefined;
    return /*#__PURE__*/_react.default.createElement(_watch_details_context.WatchDetailsContext.Provider, {
      value: {
        watchDetailError,
        watchDetail,
        isWatchDetailLoading
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      pageTitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "pageTitle"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchDetail.header",
        defaultMessage: "Current status for '{watch}'",
        values: {
          watch: watchName ? watchName : watchId
        }
      })), isSystemWatch && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.watcher.sections.watchDetail.headerBadgeToolipText",
          defaultMessage: "You cannot deactivate or delete a system watch."
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchDetail.headerBadgeText",
        defaultMessage: "System watch"
      }))))),
      bottomBorder: true,
      rightSideItems: isSystemWatch ? [] : [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "toggleWatchActivationButton",
        onClick: () => toggleWatchActivation(),
        isLoading: isTogglingActivation
      }, activationButtonText), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "deleteWatchButton",
        onClick: () => {
          setWatchesToDelete([watchId]);
        },
        color: "danger",
        disabled: false
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchHistory.deleteWatchButtonLabel",
        defaultMessage: "Delete"
      }))],
      tabs: TABS.map((tab, index) => ({
        onClick: () => {
          setSelectedTab(tab.id);
        },
        isSelected: tab.id === selectedTab,
        key: index,
        'data-test-subj': 'tab',
        label: tab.name
      }))
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), selectedPanel, /*#__PURE__*/_react.default.createElement(_components.DeleteWatchesModal, {
      callback: deleted => {
        if (deleted) {
          (0, _navigation.goToWatchList)();
        }
        setWatchesToDelete([]);
      },
      watchesToDelete: watchesToDelete
    })));
  }
  return null;
};
exports.WatchStatusPage = WatchStatusPage;