"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultQuery = exports.addHelpMenuToAppChrome = exports.addBadgeToAppChrome = void 0;
exports.getVizEditorOriginatingAppUrl = getVizEditorOriginatingAppUrl;
exports.isFallbackDataView = isFallbackDataView;
exports.visStateToEditorState = exports.redirectToSavedObjectPage = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _constants = require("../../../common/constants");
var _saved_visualize_utils = require("../../utils/saved_visualize_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const addHelpMenuToAppChrome = (chrome, docLinks) => {
  chrome.setHelpExtension({
    appName: _i18n.i18n.translate('visualizations.helpMenu.appName', {
      defaultMessage: 'Visualize Library'
    }),
    links: [{
      linkType: 'documentation',
      href: `${docLinks.links.visualize.guide}`
    }]
  });
};
exports.addHelpMenuToAppChrome = addHelpMenuToAppChrome;
const addBadgeToAppChrome = chrome => {
  chrome.setBadge({
    text: _i18n.i18n.translate('visualizations.badge.readOnly.text', {
      defaultMessage: 'Read only'
    }),
    tooltip: _i18n.i18n.translate('visualizations.badge.readOnly.tooltip', {
      defaultMessage: 'Unable to save visualizations to the library'
    }),
    iconType: 'glasses'
  });
};
exports.addBadgeToAppChrome = addBadgeToAppChrome;
const getDefaultQuery = ({
  data
}) => {
  return data.query.queryString.getDefaultQuery();
};
exports.getDefaultQuery = getDefaultQuery;
const visStateToEditorState = (visInstance, services) => {
  var _vis$data$searchSourc, _vis$data$searchSourc2;
  const vis = visInstance.vis;
  const savedVisState = (0, _saved_visualize_utils.convertFromSerializedVis)(vis.serialize());
  const savedVis = 'savedVis' in visInstance ? visInstance.savedVis : undefined;
  return {
    uiState: savedVis && savedVis.uiStateJSON ? JSON.parse(savedVis.uiStateJSON) : vis.uiState.toJSON(),
    query: ((_vis$data$searchSourc = vis.data.searchSource) === null || _vis$data$searchSourc === void 0 ? void 0 : _vis$data$searchSourc.getOwnField('query')) || getDefaultQuery(services),
    filters: ((_vis$data$searchSourc2 = vis.data.searchSource) === null || _vis$data$searchSourc2 === void 0 ? void 0 : _vis$data$searchSourc2.getOwnField('filter')) || [],
    vis: {
      ...savedVisState.visState,
      title: vis.title
    },
    linked: savedVis && savedVis.id ? !!savedVis.savedSearchId : !!savedVisState.savedSearchId
  };
};
exports.visStateToEditorState = visStateToEditorState;
const redirectToSavedObjectPage = (services, error, savedVisualizationsId) => {
  const {
    history,
    setActiveUrl,
    toastNotifications,
    http: {
      basePath
    },
    application: {
      navigateToApp
    }
  } = services;
  const managementRedirectTarget = {
    app: 'management',
    path: `kibana/objects/savedVisualizations/${savedVisualizationsId}`
  };
  (0, _public.redirectWhenMissing)({
    history,
    navigateToApp,
    toastNotifications,
    basePath,
    mapping: {
      visualization: _constants.VisualizeConstants.LANDING_PAGE_PATH,
      search: managementRedirectTarget,
      'index-pattern': managementRedirectTarget,
      'index-pattern-field': managementRedirectTarget
    },
    onBeforeRedirect() {
      setActiveUrl(_constants.VisualizeConstants.LANDING_PAGE_PATH);
    },
    theme: services.theme
  })(error);
};
exports.redirectToSavedObjectPage = redirectToSavedObjectPage;
function getVizEditorOriginatingAppUrl(history) {
  return `#/${history.location.pathname}${history.location.search}`;
}
function isFallbackDataView(dataView) {
  return Boolean(dataView && !dataView.isPersisted());
}