"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _app = require("./app");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const renderApp = ({
  element,
  onAppLeave
}, services) => {
  // add help link to visualize docs into app chrome menu
  (0, _utils.addHelpMenuToAppChrome)(services.chrome, services.docLinks);
  // add readonly badge if saving restricted
  if (!services.visualizeCapabilities.save) {
    (0, _utils.addBadgeToAppChrome)(services.chrome);
  }
  const app = /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: services.theme.theme$
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: services.history
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(services.presentationUtil.ContextProvider, null, /*#__PURE__*/_react.default.createElement(services.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewKibanaProvider, {
    core: services.core,
    toMountPoint: _public.toMountPoint,
    savedObjectsTagging: services.savedObjectsTagging,
    FormattedRelative: _i18nReact.FormattedRelative
  }, /*#__PURE__*/_react.default.createElement(_app.VisualizeApp, {
    onAppLeave: onAppLeave
  })))))));
  _reactDom.default.render(app, element);
  return () => _reactDom.default.unmountComponentAtNode(element);
};
exports.renderApp = renderApp;