"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectTimeSeriesReferences = exports.extractTimeSeriesReferences = void 0;
var _common = require("@kbn/data-views-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal **/
const REF_NAME_POSTFIX = '_ref_name';

/** @internal **/

const isMetricsVis = visType => visType === 'metrics';
const doForExtractedIndices = (action, visParams) => {
  action(visParams, 'index_pattern');
  visParams.series.forEach(series => {
    if (series.override_index_pattern) {
      action(series, 'series_index_pattern');
    }
  });
  if (visParams.annotations) {
    visParams.annotations.forEach(annotation => {
      action(annotation, 'index_pattern');
    });
  }
};
const extractTimeSeriesReferences = (visType, visParams, references = [], prefix = 'metrics') => {
  let i = 0;
  if (isMetricsVis(visType)) {
    doForExtractedIndices((object, key) => {
      if (object[key] && object[key].id) {
        const name = `${prefix}_${i++}_index_pattern`;
        object[key + REF_NAME_POSTFIX] = name;
        references.push({
          name,
          type: _common.DATA_VIEW_SAVED_OBJECT_TYPE,
          id: object[key].id
        });
        delete object[key];
      }
    }, visParams);
  }
};
exports.extractTimeSeriesReferences = extractTimeSeriesReferences;
const injectTimeSeriesReferences = (visType, visParams, references) => {
  if (isMetricsVis(visType)) {
    doForExtractedIndices((object, key) => {
      const refKey = key + REF_NAME_POSTFIX;
      if (object[refKey]) {
        const refValue = references.find(ref => ref.name === object[refKey]);
        if (refValue) {
          object[key] = {
            id: refValue.id
          };
        }
        delete object[refKey];
      }
    }, visParams);
  }
};
exports.injectTimeSeriesReferences = injectTimeSeriesReferences;