"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectControlsReferences = exports.extractControlsReferences = void 0;
var _common = require("@kbn/data-views-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isControlsVis = visType => visType === 'input_control_vis';
const extractControlsReferences = (visType, visParams, references = [], prefix = 'control') => {
  if (isControlsVis(visType)) {
    var _visParams$controls;
    ((_visParams$controls = visParams === null || visParams === void 0 ? void 0 : visParams.controls) !== null && _visParams$controls !== void 0 ? _visParams$controls : []).forEach((control, i) => {
      if (!control.indexPattern) {
        return;
      }
      control.indexPatternRefName = `${prefix}_${i}_index_pattern`;
      references.push({
        name: control.indexPatternRefName,
        type: _common.DATA_VIEW_SAVED_OBJECT_TYPE,
        id: control.indexPattern
      });
      delete control.indexPattern;
    });
  }
};
exports.extractControlsReferences = extractControlsReferences;
const injectControlsReferences = (visType, visParams, references) => {
  if (isControlsVis(visType)) {
    var _visParams$controls2;
    ((_visParams$controls2 = visParams.controls) !== null && _visParams$controls2 !== void 0 ? _visParams$controls2 : []).forEach(control => {
      if (!control.indexPatternRefName) {
        return;
      }
      const reference = references.find(ref => ref.name === control.indexPatternRefName);
      if (!reference) {
        throw new Error(`Could not find index pattern reference "${control.indexPatternRefName}"`);
      }
      control.indexPattern = reference.id;
      delete control.indexPatternRefName;
    });
  }
};
exports.injectControlsReferences = injectControlsReferences;