"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridPanel = GridPanel;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function GridPanel({
  stateParams,
  setValue
}) {
  var _stateParams$grid$val;
  const setGrid = (0, _react.useCallback)((paramName, value) => setValue('grid', {
    ...stateParams.grid,
    [paramName]: value
  }), [stateParams.grid, setValue]);
  const options = (0, _react.useMemo)(() => [...stateParams.valueAxes.map(({
    id,
    name
  }) => ({
    text: name,
    value: id
  })), {
    text: _i18n.i18n.translate('visTypeXy.controls.pointSeries.gridAxis.dontShowLabel', {
      defaultMessage: "Don't show"
    }),
    value: ''
  }], [stateParams.valueAxes]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeXy.controls.pointSeries.gridAxis.gridText",
    defaultMessage: "Grid"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.gridAxis.xAxisLinesLabel', {
      defaultMessage: 'Show X-axis lines'
    }),
    paramName: "categoryLines",
    value: stateParams.grid.categoryLines,
    setValue: setGrid,
    "data-test-subj": "showCategoryLines"
  }), /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    id: "gridAxis",
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.gridAxis.yAxisLinesLabel', {
      defaultMessage: 'Y-axis lines'
    }),
    options: options,
    paramName: "valueAxis",
    value: (_stateParams$grid$val = stateParams.grid.valueAxis) !== null && _stateParams$grid$val !== void 0 ? _stateParams$grid$val : '',
    setValue: setGrid
  }));
}