"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uniqLabels = uniqLabels;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Accepts an array of data objects and a formatter function.
 * Returns a unique list of formatted labels (strings).
 */
function uniqLabels(arr) {
  if (!Array.isArray(arr)) {
    throw new TypeError('UniqLabelUtil expects an array of objects');
  }
  return (0, _lodash.default)(arr).map('label').uniq().value();
}