"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapperStyles = exports.GlobalVegaVisStyles = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _vega_base_view = require("../vega_view/vega_base_view.styles");
var _vega_tooltip = require("../vega_view/vega_tooltip.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Styles for non-React DOM nodes that's easier to set at the Global level
const GlobalVegaVisStyles = () => {
  const euiTheme = (0, _eui.useEuiTheme)();
  const baseViewStyles = (0, _vega_base_view.vegaBaseViewStyles)(euiTheme);
  const tooltipStyles = (0, _vega_tooltip.vegaVisTooltipStyles)(euiTheme);
  return /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: [tooltipStyles, baseViewStyles]
  });
};
exports.GlobalVegaVisStyles = GlobalVegaVisStyles;
const wrapperStyles = euiTheme => (0, _react2.css)`
  ${(0, _eui.euiScrollBarStyles)(euiTheme)}
  display: flex;
  flex: 1 1 0;
  overflow: auto;
`;
exports.wrapperStyles = wrapperStyles;