"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormulaFromMetric = exports.SUPPORTED_METRICS = void 0;
var _public = require("@kbn/data-plugin/public");
var _enums = require("../../../../common/enums");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// list of supported TSVB aggregation types in Lens
// some of them are supported on the quick functions tab and some of them
// are supported with formulas
const supportedPanelTypes = [_enums.PANEL_TYPES.TIMESERIES, _enums.PANEL_TYPES.TOP_N, _enums.PANEL_TYPES.METRIC, _enums.PANEL_TYPES.GAUGE, _enums.PANEL_TYPES.TABLE];
const supportedTimeRangeModes = [_enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE, _enums.TIME_RANGE_DATA_MODES.LAST_VALUE];
const SUPPORTED_METRICS = {
  avg: {
    name: 'average',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  cardinality: {
    name: 'unique_count',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  count: {
    name: 'count',
    isFullReference: false,
    isFieldRequired: false,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  positive_rate: {
    name: 'counter_rate',
    isFullReference: true,
    isFieldRequired: true,
    supportedPanelTypes: [_enums.PANEL_TYPES.TIMESERIES],
    supportedTimeRangeModes
  },
  moving_average: {
    name: 'moving_average',
    isFullReference: true,
    isFieldRequired: true,
    supportedPanelTypes: [_enums.PANEL_TYPES.TIMESERIES],
    supportedTimeRangeModes: [_enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE]
  },
  derivative: {
    name: 'differences',
    isFullReference: true,
    isFieldRequired: true,
    supportedPanelTypes: [_enums.PANEL_TYPES.TIMESERIES],
    supportedTimeRangeModes: [_enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE]
  },
  cumulative_sum: {
    name: 'cumulative_sum',
    isFullReference: true,
    isFieldRequired: true,
    supportedPanelTypes: [_enums.PANEL_TYPES.TIMESERIES],
    supportedTimeRangeModes: [_enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE]
  },
  avg_bucket: {
    name: 'formula',
    isFullReference: true,
    isFieldRequired: true,
    isFormula: true,
    formula: 'overall_average',
    supportedPanelTypes: [_enums.PANEL_TYPES.TIMESERIES],
    supportedTimeRangeModes: [_enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE]
  },
  max_bucket: {
    name: 'formula',
    isFullReference: true,
    isFieldRequired: true,
    isFormula: true,
    formula: 'overall_max',
    supportedPanelTypes: [_enums.PANEL_TYPES.TIMESERIES],
    supportedTimeRangeModes: [_enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE]
  },
  min_bucket: {
    name: 'formula',
    isFullReference: true,
    isFieldRequired: true,
    isFormula: true,
    formula: 'overall_min',
    supportedPanelTypes: [_enums.PANEL_TYPES.TIMESERIES],
    supportedTimeRangeModes: [_enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE]
  },
  sum_bucket: {
    name: 'formula',
    isFullReference: true,
    isFieldRequired: true,
    isFormula: true,
    formula: 'overall_sum',
    supportedPanelTypes: [_enums.PANEL_TYPES.TIMESERIES],
    supportedTimeRangeModes: [_enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE]
  },
  max: {
    name: 'max',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  min: {
    name: 'min',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  percentile: {
    name: 'percentile',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  percentile_rank: {
    name: 'percentile_rank',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  sum: {
    name: 'sum',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  filter_ratio: {
    name: 'formula',
    isFullReference: false,
    isFormula: true,
    formula: 'filter_ratio',
    isFieldRequired: false,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  top_hit: {
    name: 'last_value',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  math: {
    name: 'formula',
    isFormula: true,
    formula: 'math',
    isFullReference: false,
    isFieldRequired: false,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  positive_only: {
    name: 'formula',
    isFullReference: true,
    isFieldRequired: true,
    isFormula: true,
    formula: 'pick_max',
    supportedPanelTypes: [_enums.PANEL_TYPES.TIMESERIES],
    supportedTimeRangeModes: [_enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE]
  },
  static: {
    name: 'static_value',
    isFullReference: true,
    isFieldRequired: false,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  value_count: {
    name: 'count',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  std_deviation: {
    name: 'standard_deviation',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  },
  variance: {
    name: 'formula',
    isFormula: true,
    formula: 'pow',
    isFullReference: false,
    isFieldRequired: true,
    supportedPanelTypes,
    supportedTimeRangeModes
  }
};
exports.SUPPORTED_METRICS = SUPPORTED_METRICS;
const getFormulaFromMetric = metric => {
  if (metric.isFormula) {
    return metric.formula;
  }
  return metric.name;
};
exports.getFormulaFromMetric = getFormulaFromMetric;