"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToStandartDeviationColumn = void 0;
var _metrics = require("../metrics");
var _formula = require("./formula");
var _parent_pipeline = require("./parent_pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createStandartDeviationFormulaColumn = ({
  series,
  metric,
  dataView
}, metrics, reducedTimeRange) => {
  const script = (0, _metrics.getFormulaEquivalent)(metric, metrics, {
    reducedTimeRange,
    timeShift: series.offset_time
  });
  if (!script) return null;
  return (0, _formula.createFormulaColumn)(script, {
    series,
    metric,
    dataView
  });
};
const convertToStandartDeviationColumn = ({
  series,
  metrics,
  dataView
}, reducedTimeRange) => {
  const metric = metrics[metrics.length - 1];
  const field = metric.field ? dataView.getFieldByName(metric.field) : undefined;
  if (!field) {
    return null;
  }
  const columns = [];
  if (metric.mode === 'upper' || metric.mode === 'lower') {
    columns.push(createStandartDeviationFormulaColumn({
      series,
      metric,
      dataView
    }, metrics, reducedTimeRange));
  } else if (metric.mode === 'band') {
    [{
      ...metric,
      mode: 'upper'
    }, {
      ...metric,
      mode: 'lower'
    }].forEach(m => {
      columns.push(createStandartDeviationFormulaColumn({
        series,
        metric: m,
        dataView
      }, metrics, reducedTimeRange));
    });
  } else {
    columns.push((0, _parent_pipeline.convertMetricAggregationColumnWithoutSpecialParams)(_metrics.SUPPORTED_METRICS.std_deviation, {
      series,
      metrics: [metric],
      dataView
    }, {
      reducedTimeRange,
      timeShift: series.offset_time
    }));
  }
  return columns;
};
exports.convertToStandartDeviationColumn = convertToStandartDeviationColumn;