"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToCounterRateColumn = void 0;
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _column = require("./column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertToCounterRateColumn = ({
  series,
  metrics,
  dataView
}) => {
  const metric = metrics[metrics.length - 1];
  const field = metric.field ? dataView.getFieldByName(metric.field) : undefined;
  if (!field) {
    return null;
  }
  const maxColumn = {
    operationType: _convert_to_lens.Operations.MAX,
    sourceField: field.name,
    ...(0, _column.createColumn)(series, metric, field),
    params: {
      ...(0, _column.getFormat)(series)
    }
  };
  return [maxColumn, {
    operationType: _convert_to_lens.Operations.COUNTER_RATE,
    references: [maxColumn.columnId],
    ...(0, _column.createColumn)(series, metric, field, {
      timeShift: series.offset_time
    }),
    params: {
      ...(0, _column.getFormat)(series)
    }
  }];
};
exports.convertToCounterRateColumn = convertToCounterRateColumn;