"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.outputFormats = exports.isDuration = exports.inputFormats = exports.getDurationParams = exports.durationOutputOptions = exports.durationInputOptions = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const durationBaseOptions = [{
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.millisecondsLabel', {
    defaultMessage: 'Milliseconds'
  }),
  value: 'ms'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.secondsLabel', {
    defaultMessage: 'Seconds'
  }),
  value: 's'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.minutesLabel', {
    defaultMessage: 'Minutes'
  }),
  value: 'm'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.hoursLabel', {
    defaultMessage: 'Hours'
  }),
  value: 'h'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.daysLabel', {
    defaultMessage: 'Days'
  }),
  value: 'd'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.weeksLabel', {
    defaultMessage: 'Weeks'
  }),
  value: 'w'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.monthsLabel', {
    defaultMessage: 'Months'
  }),
  value: 'M'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.yearsLabel', {
    defaultMessage: 'Years'
  }),
  value: 'Y'
}];
const durationOutputOptions = [{
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.humanize', {
    defaultMessage: 'Human readable'
  }),
  value: 'humanize'
}, ...durationBaseOptions];
exports.durationOutputOptions = durationOutputOptions;
const durationInputOptions = [{
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.picosecondsLabel', {
    defaultMessage: 'Picoseconds'
  }),
  value: 'ps'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.nanosecondsLabel', {
    defaultMessage: 'Nanoseconds'
  }),
  value: 'ns'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.durationOptions.microsecondsLabel', {
    defaultMessage: 'Microseconds'
  }),
  value: 'us'
}, ...durationBaseOptions];
exports.durationInputOptions = durationInputOptions;
const inputFormats = {
  ps: 'picoseconds',
  ns: 'nanoseconds',
  us: 'microseconds',
  ms: 'milliseconds',
  s: 'seconds',
  m: 'minutes',
  h: 'hours',
  d: 'days',
  w: 'weeks',
  M: 'months',
  Y: 'years'
};
exports.inputFormats = inputFormats;
const outputFormats = {
  humanize: 'humanize',
  ms: 'asMilliseconds',
  s: 'asSeconds',
  m: 'asMinutes',
  h: 'asHours',
  d: 'asDays',
  w: 'asWeeks',
  M: 'asMonths',
  Y: 'asYears'
};
exports.outputFormats = outputFormats;
const getDurationParams = format => {
  const [from, to, decimals] = format.split(',');
  return {
    from: from,
    to: to,
    decimals
  };
};
exports.getDurationParams = getDurationParams;
const isDuration = format => {
  const splittedFormat = format.split(',');
  const [input, output] = splittedFormat;
  return Boolean(inputFormats[input] && outputFormats[output]) && splittedFormat.length === 3;
};
exports.isDuration = isDuration;