"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataFormatPicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _enums = require("../../../common/enums");
var _get_formatter_type = require("./lib/get_formatter_type");
var _durations = require("./lib/durations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_OUTPUT_PRECISION = '2';
const DEFAULT_CUSTOM_FORMAT_PATTERN = '0,0.[000]';
const defaultOptionLabel = _i18n.i18n.translate('visTypeTimeseries.dataFormatPicker.defaultLabel', {
  defaultMessage: 'Default'
});
const getDataFormatPickerOptions = (shouldIncludeDefaultOption, shouldIncludeNumberOptions) => {
  const additionalOptions = [];
  if (shouldIncludeDefaultOption) {
    additionalOptions.push({
      value: _enums.DATA_FORMATTERS.DEFAULT,
      inputDisplay: defaultOptionLabel,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, defaultOptionLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('visTypeTimeseries.dataFormatPicker.defaultLabelDescription', {
        defaultMessage: 'Applies common formatting'
      })))),
      'data-test-subj': `tsvbDataFormatPicker-${_enums.DATA_FORMATTERS.DEFAULT}`
    });
  }
  if (shouldIncludeNumberOptions) {
    additionalOptions.push({
      value: _enums.DATA_FORMATTERS.NUMBER,
      inputDisplay: _i18n.i18n.translate('visTypeTimeseries.dataFormatPicker.numberLabel', {
        defaultMessage: 'Number'
      }),
      'data-test-subj': `tsvbDataFormatPicker-${_enums.DATA_FORMATTERS.NUMBER}`
    }, {
      value: _enums.DATA_FORMATTERS.BYTES,
      inputDisplay: _i18n.i18n.translate('visTypeTimeseries.dataFormatPicker.bytesLabel', {
        defaultMessage: 'Bytes'
      }),
      'data-test-subj': `tsvbDataFormatPicker-${_enums.DATA_FORMATTERS.BYTES}`
    }, {
      value: _enums.DATA_FORMATTERS.PERCENT,
      inputDisplay: _i18n.i18n.translate('visTypeTimeseries.dataFormatPicker.percentLabel', {
        defaultMessage: 'Percent'
      }),
      'data-test-subj': `tsvbDataFormatPicker-${_enums.DATA_FORMATTERS.PERCENT}`
    }, {
      value: _enums.DATA_FORMATTERS.DURATION,
      inputDisplay: _i18n.i18n.translate('visTypeTimeseries.dataFormatPicker.durationLabel', {
        defaultMessage: 'Duration'
      }),
      'data-test-subj': `tsvbDataFormatPicker-${_enums.DATA_FORMATTERS.DURATION}`
    });
  }
  return [...additionalOptions, {
    value: _enums.DATA_FORMATTERS.CUSTOM,
    inputDisplay: _i18n.i18n.translate('visTypeTimeseries.dataFormatPicker.customLabel', {
      defaultMessage: 'Custom'
    }),
    'data-test-subj': `tsvbDataFormatPicker-${_enums.DATA_FORMATTERS.CUSTOM}`
  }];
};
const htmlId = (0, _eui.htmlIdGenerator)();
const DataFormatPicker = ({
  formatterValue,
  changeModelFormatter,
  shouldIncludeDefaultOption,
  shouldIncludeNumberOptions
}) => {
  const options = (0, _react.useMemo)(() => getDataFormatPickerOptions(shouldIncludeDefaultOption, shouldIncludeNumberOptions), [shouldIncludeDefaultOption, shouldIncludeNumberOptions]);
  const [selectedFormatter, setSelectedFormatter] = (0, _react.useState)((0, _get_formatter_type.getFormatterType)(formatterValue));
  const [customFormatPattern, setCustomFormatPattern] = (0, _react.useState)(selectedFormatter === _enums.DATA_FORMATTERS.CUSTOM ? formatterValue : '');
  const [durationParams, setDurationParams] = (0, _react.useState)((0, _durations.getDurationParams)(selectedFormatter === _enums.DATA_FORMATTERS.DURATION ? formatterValue : 'ms,ms,'));
  (0, _react.useEffect)(() => {
    // formatter value is set to the first option in case options do not include selected formatter
    if (!options.find(({
      value
    }) => value === selectedFormatter)) {
      const [{
        value: firstOptionValue
      }] = options;
      setSelectedFormatter(firstOptionValue);
      changeModelFormatter(firstOptionValue);
    }
  }, [options, selectedFormatter, changeModelFormatter]);
  const handleChange = (0, _react.useCallback)(selectedOption => {
    setSelectedFormatter(selectedOption);
    if (selectedOption === _enums.DATA_FORMATTERS.DURATION) {
      const {
        from,
        to,
        decimals
      } = durationParams;
      changeModelFormatter(`${from},${to},${decimals}`);
    } else if (selectedOption === _enums.DATA_FORMATTERS.CUSTOM) {
      changeModelFormatter(customFormatPattern);
    } else {
      changeModelFormatter(selectedOption);
    }
  }, [changeModelFormatter, customFormatPattern, durationParams]);
  const handleCustomFormatStringChange = (0, _react.useCallback)(event => {
    const stringPattern = event.target.value;
    changeModelFormatter(stringPattern);
    setCustomFormatPattern(stringPattern);
  }, [changeModelFormatter]);
  const handleDurationParamsChange = (0, _react.useCallback)((paramName, paramValue) => {
    const newDurationParams = {
      ...durationParams,
      [paramName]: paramValue
    };
    setDurationParams(newDurationParams);
    const {
      from,
      to,
      decimals
    } = newDurationParams;
    changeModelFormatter(`${from},${to},${decimals}`);
  }, [changeModelFormatter, durationParams]);
  const handleDurationChange = (0, _react.useCallback)(optionName => {
    return ([{
      value
    }]) => handleDurationParamsChange(optionName, value);
  }, [handleDurationParamsChange]);
  const handleDecimalsChange = (0, _react.useCallback)(event => handleDurationParamsChange('decimals', event.target.value), [handleDurationParamsChange]);
  let duration;
  if (selectedFormatter === _enums.DATA_FORMATTERS.DURATION) {
    const {
      from,
      to,
      decimals = DEFAULT_OUTPUT_PRECISION
    } = durationParams;
    const selectedFrom = _durations.durationInputOptions.find(({
      value
    }) => value === from);
    const selectedTo = _durations.durationOutputOptions.find(({
      value
    }) => value === to);
    duration = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('from'),
      label: _i18n.i18n.translate('visTypeTimeseries.dataFormatPicker.fromLabel', {
        defaultMessage: 'From'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isClearable: false,
      options: _durations.durationInputOptions,
      selectedOptions: selectedFrom ? [selectedFrom] : [],
      onChange: handleDurationChange('from'),
      singleSelection: {
        asPlainText: true
      },
      "data-test-subj": "dataFormatPickerDurationFrom"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('to'),
      label: _i18n.i18n.translate('visTypeTimeseries.dataFormatPicker.toLabel', {
        defaultMessage: 'To'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isClearable: false,
      options: _durations.durationOutputOptions,
      selectedOptions: selectedTo ? [selectedTo] : [],
      onChange: handleDurationChange('to'),
      singleSelection: {
        asPlainText: true
      },
      "data-test-subj": "dataFormatPickerDurationTo"
    }))), (selectedTo === null || selectedTo === void 0 ? void 0 : selectedTo.value) !== 'humanize' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('decimal'),
      label: _i18n.i18n.translate('visTypeTimeseries.dataFormatPicker.decimalPlacesLabel', {
        defaultMessage: 'Decimal places'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      defaultValue: decimals,
      placeholder: DEFAULT_OUTPUT_PRECISION,
      onChange: handleDecimalsChange,
      "data-test-subj": "dataFormatPickerDurationDecimal"
    }))));
  }
  let custom;
  if (selectedFormatter === _enums.DATA_FORMATTERS.CUSTOM && shouldIncludeNumberOptions) {
    custom = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.dataFormatPicker.formatPatternLabel",
        defaultMessage: "Numeral.js format pattern (Default: {defaultPattern})",
        values: {
          defaultPattern: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, DEFAULT_CUSTOM_FORMAT_PATTERN)
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: "http://numeraljs.com/#format"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.dataFormatPicker.formatPatternHelpText",
        defaultMessage: "Documentation"
      })))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      placeholder: DEFAULT_CUSTOM_FORMAT_PATTERN,
      value: customFormatPattern,
      onChange: handleCustomFormatStringChange
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypeTimeseries.defaultDataFormatterLabel', {
      defaultMessage: 'Data formatter'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: options,
    valueOfSelected: selectedFormatter,
    onChange: handleChange,
    "data-test-subj": "tsvbDataFormatPicker",
    fullWidth: true,
    hasDividers: true
  }))), selectedFormatter === _enums.DATA_FORMATTERS.DURATION && duration, selectedFormatter === _enums.DATA_FORMATTERS.CUSTOM && custom);
};
exports.DataFormatPicker = DataFormatPicker;