"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newPercentile = exports.Percentiles = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../../../../common/constants");
var _collection_actions = require("../lib/collection_actions");
var _add_delete_buttons = require("../add_delete_buttons");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _color_picker = require("../color_picker");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const newPercentile = opts => {
  return _lodash.default.assign({
    id: (0, _uuid.v4)(),
    mode: 'line',
    shade: 0.2,
    color: _constants.TSVB_DEFAULT_COLOR
  }, opts);
};
exports.newPercentile = newPercentile;
class Percentiles extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "renderRow", (row, i, items) => {
      const defaults = {
        value: '',
        percentile: '',
        shade: '',
        color: _constants.TSVB_DEFAULT_COLOR
      };
      const model = {
        ...defaults,
        ...row
      };
      const {
        panel,
        seriesId
      } = this.props;
      const flexItemStyle = {
        minWidth: 100
      };
      const percentileSeries = panel.series.find(s => s.id === seriesId) || panel.series[0];
      const isGroupedBy = panel.series.length > 0 && percentileSeries.split_mode !== 'everything';
      const percentileFieldNumber = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: flexItemStyle
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.percentile.percentile",
          defaultMessage: "Percentile"
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        "aria-label": _i18n.i18n.translate('visTypeTimeseries.percentile.percentileAriaLabel', {
          defaultMessage: 'Percentile'
        }),
        placeholder: 0,
        max: 100,
        min: 0,
        step: 1,
        onChange: this.handleTextChange(model, 'value'),
        value: model.value === '' ? '' : Number(model.value)
      })));
      if (panel.type === 'table') {
        return percentileFieldNumber;
      }
      const handleAdd = _collection_actions.collectionActions.handleAdd.bind(null, this.props, newPercentile);
      const handleDelete = _collection_actions.collectionActions.handleDelete.bind(null, this.props, model);
      const modeOptions = [{
        label: _i18n.i18n.translate('visTypeTimeseries.percentile.modeOptions.lineLabel', {
          defaultMessage: 'Line'
        }),
        value: 'line'
      }, {
        label: _i18n.i18n.translate('visTypeTimeseries.percentile.modeOptions.bandLabel', {
          defaultMessage: 'Band'
        }),
        value: 'band'
      }];
      const optionsStyle = {
        ...flexItemStyle
      };
      if (model.mode === 'line') {
        optionsStyle.display = 'none';
      }
      const htmlId = (0, _eui.htmlIdGenerator)(model.id);
      const selectedModeOption = modeOptions.find(option => {
        return model.mode === option.value;
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: model.id
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        key: model.id,
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
        columns: 3
      }, !isGroupedBy && !['table', 'metric', 'markdown'].includes(panel.type) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        style: {
          justifyContent: 'center'
        }
      }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
        disableTrash: true,
        onChange: this.handleColorChange(model),
        value: model.color,
        name: "color"
      })), percentileFieldNumber, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: flexItemStyle
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.percentile.modeLabel",
          defaultMessage: "Mode:"
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        isClearable: false,
        id: htmlId('mode'),
        options: modeOptions,
        selectedOptions: selectedModeOption ? [selectedModeOption] : [],
        onChange: this.handleTextChange(model, 'mode'),
        singleSelection: {
          asPlainText: true
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: optionsStyle
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.percentile.fillToLabel",
          defaultMessage: "Fill to:"
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        id: htmlId('fillTo'),
        min: 0,
        max: 100,
        step: 1,
        onChange: this.handleTextChange(model, 'percentile'),
        value: Number(model.percentile)
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: optionsStyle
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.percentile.shadeLabel",
          defaultMessage: "Shade (0 to 1):"
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        id: htmlId('shade'),
        step: 0.1,
        onChange: this.handleTextChange(model, 'shade'),
        value: Number(model.shade)
      }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
        onAdd: handleAdd,
        onDelete: handleDelete,
        disableDelete: items.length < 2,
        responsive: false
      })))));
    });
  }
  handleTextChange(item, name) {
    return e => {
      const handleChange = _collection_actions.collectionActions.handleChange.bind(null, this.props);
      const part = {};
      part[name] = _lodash.default.get(e, '[0].value', _lodash.default.get(e, 'target.value'));
      handleChange(_lodash.default.assign({}, item, part));
    };
  }
  handleColorChange(item) {
    return val => {
      const handleChange = _collection_actions.collectionActions.handleChange.bind(null, this.props);
      handleChange(_lodash.default.assign({}, item, val));
    };
  }
  render() {
    const {
      model,
      name,
      panel
    } = this.props;
    if (!model[name]) return /*#__PURE__*/_react.default.createElement("div", null);
    let rows;
    if (panel.type === 'table') {
      rows = this.renderRow(_lodash.default.last(model[name]));
    } else {
      rows = model[name].map(this.renderRow);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, rows);
  }
}
exports.Percentiles = Percentiles;
Percentiles.defaultProps = {
  name: 'percentile'
};
Percentiles.propTypes = {
  name: _propTypes.default.string,
  model: _propTypes.default.object,
  panel: _propTypes.default.object,
  onChange: _propTypes.default.func,
  seriesId: _propTypes.default.string
};