"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToLens = void 0;
var _public = require("@kbn/visualizations-plugin/public");
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _uuid = require("uuid");
var _services = require("../services");
var _configurations = require("./configurations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertToLens = async (vis, timefilter) => {
  var _vis$data$indexPatter;
  if (!timefilter) {
    return null;
  }
  const dataViews = (0, _services.getDataViewsStart)();
  const dataView = await (0, _public.getDataViewByIndexPatternId)((_vis$data$indexPatter = vis.data.indexPattern) === null || _vis$data$indexPatter === void 0 ? void 0 : _vis$data$indexPatter.id, dataViews);
  if (!dataView) {
    return null;
  }
  const {
    getColumnsFromVis,
    getPercentageColumnFormulaColumn
  } = await _public.convertToLensModule;
  const layers = getColumnsFromVis(vis, timefilter, dataView, {
    buckets: ['bucket'],
    splits: ['split_row', 'split_column']
  }, {
    dropEmptyRowsInDateHistogram: true,
    isPercentageMode: false
  });
  if (layers === null) {
    return null;
  }
  const [layerConfig] = layers;
  if (vis.params.percentageCol) {
    const visSchemas = (0, _public.getVisSchemas)(vis, {
      timefilter,
      timeRange: timefilter.getAbsoluteTime()
    });
    const metricAgg = visSchemas.metric.find(m => m.label === vis.params.percentageCol);
    if (!metricAgg) {
      return null;
    }
    const percentageColumn = getPercentageColumnFormulaColumn({
      visType: vis.type.name,
      agg: metricAgg,
      dataView,
      aggs: visSchemas.metric
    });
    if (!percentageColumn) {
      return null;
    }
    layerConfig.columns.splice(layerConfig.columnsWithoutReferenced.findIndex(c => c.meta.aggId === metricAgg.aggId) + 1, 0, percentageColumn);
    layerConfig.columnsWithoutReferenced.push(percentageColumn);
  }
  const layerId = (0, _uuid.v4)();
  const indexPatternId = dataView.id;
  return {
    type: 'lnsDatatable',
    layers: [{
      indexPatternId,
      layerId,
      columns: layerConfig.columns.map(_convert_to_lens.excludeMetaFromColumn),
      columnOrder: [],
      ignoreGlobalFilters: false
    }],
    configuration: (0, _configurations.getConfiguration)(layerId, vis.params, layerConfig),
    indexPatternIds: [indexPatternId]
  };
};
exports.convertToLens = convertToLens;