"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelsPanel = LabelsPanel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/vis-default-editor-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const VERTICAL_ROTATION = 270;
function LabelsPanel({
  valueAxis,
  setValue,
  isNewLibrary
}) {
  const rotateLabels = valueAxis.labels.rotate === VERTICAL_ROTATION;
  const setValueAxisLabels = (0, _react.useCallback)((paramName, value) => setValue('valueAxes', [{
    ...valueAxis,
    labels: {
      ...valueAxis.labels,
      [paramName]: value
    }
  }]), [valueAxis, setValue]);
  const setRotateLabels = (0, _react.useCallback)((paramName, value) => setValueAxisLabels(paramName, value ? VERTICAL_ROTATION : 0), [setValueAxisLabels]);
  const setColor = (0, _react.useCallback)(value => setValueAxisLabels('color', value), [setValueAxisLabels]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeHeatmap.controls.heatmapOptions.labelsTitle",
    defaultMessage: "Labels"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeHeatmap.controls.heatmapOptions.showLabelsTitle', {
      defaultMessage: 'Show labels'
    }),
    paramName: "show",
    value: Boolean(valueAxis.labels.show),
    setValue: setValueAxisLabels
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    disabled: !valueAxis.labels.show || isNewLibrary,
    label: _i18n.i18n.translate('visTypeHeatmap.controls.heatmapOptions.rotateLabel', {
      defaultMessage: 'Rotate'
    }),
    "data-test-subj": "heatmapLabelsRotate",
    paramName: "rotate",
    value: rotateLabels,
    setValue: setRotateLabels,
    tooltip: _i18n.i18n.translate('visTypeHeatmap.editors.heatmap.rotateLabelNotAvailable', {
      defaultMessage: 'Rotate label is not supported with the new charts library. Please enable the heatmap legacy charts library advanced setting.'
    })
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    disabled: !valueAxis.labels.show || isNewLibrary,
    label: _i18n.i18n.translate('visTypeHeatmap.controls.heatmapOptions.overwriteAutomaticColorLabel', {
      defaultMessage: 'Overwrite automatic color'
    }),
    paramName: "overwriteColor",
    value: Boolean(valueAxis.labels.overwriteColor),
    setValue: setValueAxisLabels,
    "data-test-subj": "heatmapLabelsOverwriteColor",
    tooltip: _i18n.i18n.translate('visTypeHeatmap.editors.heatmap.overwriteColorlNotAvailable', {
      defaultMessage: 'Overwrite automatic color is not supported with the new charts library. Please enable the heatmap legacy charts library advanced setting .'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('visTypeHeatmap.controls.heatmapOptions.colorLabel', {
      defaultMessage: 'Color'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    compressed: true,
    fullWidth: true,
    "data-test-subj": "heatmapLabelsColor",
    disabled: !valueAxis.labels.show || !valueAxis.labels.overwriteColor || isNewLibrary,
    color: valueAxis.labels.color,
    onChange: setColor
  })));
}