"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorSchemaOptions = ColorSchemaOptions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _select = require("./select");
var _switch = require("./switch");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ColorSchemaOptions({
  disabled,
  colorSchema,
  colorSchemas,
  invertColors,
  uiState,
  setValue,
  showHelpText = true
}) {
  const [isCustomColors, setIsCustomColors] = (0, _react.useState)(() => !!uiState.get('vis.colors'));
  (0, _react.useEffect)(() => {
    uiState.on('colorChanged', () => {
      setIsCustomColors(true);
    });
  }, [uiState]);
  const resetColorsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      uiState.set('vis.colors', null);
      uiState === null || uiState === void 0 ? void 0 : uiState.emit('reload');
      setIsCustomColors(false);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.options.colorSchema.resetColorsButtonLabel",
    defaultMessage: "Reset colors"
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_select.SelectOption, {
    disabled: disabled,
    helpText: showHelpText && _i18n.i18n.translate('visDefaultEditor.options.colorSchema.howToChangeColorsDescription', {
      defaultMessage: 'Individual colors can be changed in the legend.'
    }),
    label: _i18n.i18n.translate('visDefaultEditor.options.colorSchema.colorSchemaLabel', {
      defaultMessage: 'Color schema'
    }),
    labelAppend: isCustomColors && resetColorsButton,
    options: colorSchemas,
    paramName: "colorSchema",
    value: colorSchema,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_switch.SwitchOption, {
    disabled: disabled,
    label: _i18n.i18n.translate('visDefaultEditor.options.colorSchema.reverseColorSchemaLabel', {
      defaultMessage: 'Reverse schema'
    }),
    paramName: "invertColors",
    value: invertColors,
    setValue: setValue
  }));
}