"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingBucketParamEditor = MissingBucketParamEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _switch = require("./switch");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function MissingBucketParamEditor(props) {
  const fieldTypeIsNotString = !_public.search.aggs.isStringType(props.agg);
  const {
    setValue
  } = props;
  (0, _react.useEffect)(() => {
    if (fieldTypeIsNotString) {
      setValue(false);
    }
  }, [fieldTypeIsNotString, setValue]);
  return /*#__PURE__*/_react.default.createElement(_switch.SwitchParamEditor, (0, _extends2.default)({}, props, {
    dataTestSubj: "missingBucketSwitch",
    displayLabel: _i18n.i18n.translate('visDefaultEditor.controls.otherBucket.showMissingValuesLabel', {
      defaultMessage: 'Show missing values'
    }),
    displayToolTip: _i18n.i18n.translate('visDefaultEditor.controls.otherBucket.showMissingValuesTooltip', {
      defaultMessage: 'Only works for fields of type "string". When enabled, include documents with missing ' + 'values in the search. If this bucket is in the top N, it appears in the chart. ' + 'If not in the top N, and you enable "Group other values in separate bucket", ' + 'Elasticsearch adds the missing values to the "other" bucket.'
    }),
    disabled: fieldTypeIsNotString
  }));
}