"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExtendedBoundsParamEditor = ExtendedBoundsParamEditor;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function areBoundsValid({
  min,
  max
}) {
  if (min === '' || max === '') {
    return false;
  }
  return max >= min;
}
function ExtendedBoundsParamEditor({
  value = {},
  setValue,
  setValidity,
  showValidation,
  setTouched
}) {
  const minLabel = _i18n.i18n.translate('visDefaultEditor.controls.extendedBounds.minLabel', {
    defaultMessage: 'Min'
  });
  const maxLabel = _i18n.i18n.translate('visDefaultEditor.controls.extendedBounds.maxLabel', {
    defaultMessage: 'Max'
  });
  const isValid = areBoundsValid(value);
  let error;
  if (!isValid) {
    error = _i18n.i18n.translate('visDefaultEditor.controls.extendedBounds.errorMessage', {
      defaultMessage: 'Min should be less than or equal to Max.'
    });
  }
  (0, _utils.useValidation)(setValidity, isValid);
  const handleChange = (ev, name) => {
    setValue({
      ...value,
      [name]: ev.target.value === '' ? '' : parseFloat(ev.target.value)
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    error: error
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: (0, _lodash.isUndefined)(value.min) ? '' : value.min,
    onChange: ev => handleChange(ev, 'min'),
    onBlur: setTouched,
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    "aria-label": minLabel,
    prepend: minLabel,
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: (0, _lodash.isUndefined)(value.max) ? '' : value.max,
    onChange: ev => handleChange(ev, 'max'),
    onBlur: setTouched,
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    "aria-label": maxLabel,
    prepend: maxLabel,
    compressed: true
  }))));
}