"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputList = InputList;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// InputModel can have the following implementations:
// for Mask List - { id: 'someId', mask: { model: '', value: '', isInvalid: false }}
// for FromTo List - { id: 'someId', from: { model: '', value: '', isInvalid: false }, to: { model: '', value: '', isInvalid: false }}
const generateId = (0, _eui.htmlIdGenerator)();
const validateValue = (inputValue, InputObject) => {
  const result = {
    model: inputValue || '',
    isInvalid: false
  };
  if (!inputValue) {
    result.isInvalid = false;
    return result;
  }
  try {
    result.model = new InputObject(inputValue).toString();
    result.isInvalid = false;
    return result;
  } catch (e) {
    result.isInvalid = true;
    return result;
  }
};
function InputList({
  config,
  list,
  onChange,
  setValidity
}) {
  const {
    defaultValue,
    getModelValue,
    modelNames,
    onChangeFn,
    validateClass
  } = config;
  const [models, setModels] = (0, _react.useState)(() => list.map(item => ({
    id: generateId(),
    ...getModelValue(item)
  })));
  const hasInvalidValues = models.some(config.hasInvalidValuesFn);
  const updateValues = (0, _react.useCallback)(modelList => {
    setModels(modelList);
    onChange(modelList.map(onChangeFn));
  }, [onChangeFn, onChange]);
  const onChangeValue = (0, _react.useCallback)((index, value, modelName) => {
    const {
      model,
      isInvalid
    } = validateValue(value, validateClass);
    updateValues(models.map((range, arrayIndex) => arrayIndex === index ? {
      ...range,
      [modelName]: {
        value,
        model,
        isInvalid
      }
    } : range));
  }, [models, updateValues, validateClass]);
  const onDelete = (0, _react.useCallback)(id => updateValues(models.filter(model => model.id !== id)), [models, updateValues]);
  const onAdd = (0, _react.useCallback)(() => updateValues([...models, {
    id: generateId(),
    ...getModelValue()
  }]), [getModelValue, models, updateValues]);
  (0, _react.useEffect)(() => {
    // resposible for setting up an initial value when there is no default value
    if (!list.length) {
      updateValues([{
        id: generateId(),
        ...defaultValue
      }]);
    }
  }, [defaultValue, list.length, updateValues]);
  (0, _react.useEffect)(() => {
    setValidity(!hasInvalidValues);
  }, [hasInvalidValues, setValidity]);
  (0, _react.useEffect)(() => {
    // responsible for discarding changes
    if (list.length !== models.length || list.some((item, index) => {
      // make model to be the same shape as stored value
      const model = (0, _lodash.mapValues)((0, _lodash.pick)(models[index], modelNames), 'model');

      // we need to skip empty values since they are not stored in saved object
      return !(0, _lodash.isEqual)(item, (0, _lodash.omitBy)(model, _lodash.isEmpty));
    })) {
      setModels(list.map(item => ({
        id: generateId(),
        ...getModelValue(item)
      })));
    }
  }, [getModelValue, list, modelNames, models]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, models.map((item, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: item.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, config.renderInputRow(item, index, onChangeValue), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": config.getRemoveBtnAriaLabel(item),
    title: config.getRemoveBtnAriaLabel(item),
    disabled: models.length === 1,
    color: "danger",
    iconType: "trash",
    onClick: () => onDelete(item.id)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAdd,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.ipRanges.addRangeButtonLabel",
    defaultMessage: "Add range"
  }))));
}