"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Metrics = Metrics;
var React = _interopRequireWildcard(require("react"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _use_client_metrics_query = require("../../../../hooks/use_client_metrics_query");
var _translations = require("../translations");
var _key_ux_metrics = require("../ux_metrics/key_ux_metrics");
var _csm_shared_context = require("../csm_shared_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  flex-direction: row;
  @media only screen and (max-width: 768px) {
    flex-direction: row;
    justify-content: space-between;
  }
`;
function formatTitle(unit, value) {
  if (typeof value === 'undefined') return _translations.I18LABELS.dataMissing;
  return (0, _key_ux_metrics.formatToSec)(value, unit);
}
function PageViewsTotalTitle({
  pageViews
}) {
  if (typeof pageViews === 'undefined') {
    return /*#__PURE__*/React.createElement(React.Fragment, null, _translations.I18LABELS.dataMissing);
  }
  return pageViews < 10000 ? /*#__PURE__*/React.createElement(React.Fragment, null, (0, _numeral.default)(pageViews).format('0,0')) : /*#__PURE__*/React.createElement(_eui.EuiToolTip, {
    content: (0, _numeral.default)(pageViews).format('0,0')
  }, /*#__PURE__*/React.createElement(React.Fragment, null, (0, _numeral.default)(pageViews).format('0 a')));
}
function Metrics() {
  var _data$totalPageLoadDu, _data$backEnd, _data$frontEnd, _data$pageViews2;
  const {
    data,
    loading
  } = (0, _use_client_metrics_query.useClientMetricsQuery)();
  const {
    setSharedData
  } = (0, React.useContext)(_csm_shared_context.CsmSharedContext);
  (0, React.useEffect)(() => {
    var _data$pageViews$value, _data$pageViews;
    setSharedData({
      totalPageViews: (_data$pageViews$value = data === null || data === void 0 ? void 0 : (_data$pageViews = data.pageViews) === null || _data$pageViews === void 0 ? void 0 : _data$pageViews.value) !== null && _data$pageViews$value !== void 0 ? _data$pageViews$value : 0
    });
  }, [data, setSharedData]);
  const STAT_STYLE = {
    minWidth: '150px',
    maxWidth: '250px'
  };
  return /*#__PURE__*/React.createElement(ClFlexGroup, {
    wrap: true,
    responsive: false
  }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: STAT_STYLE
  }, /*#__PURE__*/React.createElement(_eui.EuiStat, {
    "data-test-subj": 'uxClientMetrics-totalPageLoad',
    titleSize: "l",
    title: formatTitle('ms', data === null || data === void 0 ? void 0 : (_data$totalPageLoadDu = data.totalPageLoadDuration) === null || _data$totalPageLoadDu === void 0 ? void 0 : _data$totalPageLoadDu.value),
    description: /*#__PURE__*/React.createElement(React.Fragment, null, _translations.I18LABELS.totalPageLoad, /*#__PURE__*/React.createElement(_eui.EuiIconTip, {
      content: _translations.I18LABELS.totalPageLoadTooltip,
      type: "questionInCircle"
    })),
    isLoading: !!loading
  })), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: STAT_STYLE
  }, /*#__PURE__*/React.createElement(_eui.EuiStat, {
    "data-test-subj": 'uxClientMetrics-backend',
    titleSize: "l",
    title: formatTitle('ms', data === null || data === void 0 ? void 0 : (_data$backEnd = data.backEnd) === null || _data$backEnd === void 0 ? void 0 : _data$backEnd.value),
    description: /*#__PURE__*/React.createElement(React.Fragment, null, _translations.I18LABELS.backEnd, /*#__PURE__*/React.createElement(_eui.EuiIconTip, {
      content: _translations.I18LABELS.backEndTooltip,
      type: "questionInCircle"
    })),
    isLoading: !!loading
  })), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: STAT_STYLE
  }, /*#__PURE__*/React.createElement(_eui.EuiStat, {
    "data-test-subj": 'uxClientMetrics-frontend',
    titleSize: "l",
    title: formatTitle('ms', data === null || data === void 0 ? void 0 : (_data$frontEnd = data.frontEnd) === null || _data$frontEnd === void 0 ? void 0 : _data$frontEnd.value),
    description: /*#__PURE__*/React.createElement(React.Fragment, null, _translations.I18LABELS.frontEnd, /*#__PURE__*/React.createElement(_eui.EuiIconTip, {
      content: _translations.I18LABELS.frontEndTooltip,
      type: "questionInCircle"
    })),
    isLoading: !!loading
  })), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: STAT_STYLE
  }, /*#__PURE__*/React.createElement(_eui.EuiStat, {
    "data-test-subj": 'uxClientMetrics-pageViews',
    titleSize: "l",
    title: /*#__PURE__*/React.createElement(PageViewsTotalTitle, {
      pageViews: data === null || data === void 0 ? void 0 : (_data$pageViews2 = data.pageViews) === null || _data$pageViews2 === void 0 ? void 0 : _data$pageViews2.value
    }),
    description: _translations.I18LABELS.pageViews,
    isLoading: !!loading
  })));
}